/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.compilers.JRBshCalculator;
import net.sf.jasperreports.compilers.JRBshGenerator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSaver;

public class JRBshCompiler
implements JRCompiler {
    public JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        JasperReport jasperReport = null;
        if (!"java".equals(jasperDesign.getLanguage())) {
            throw new JRException("Language \"" + jasperDesign.getLanguage() + "\" not supported by this report compiler.\nExpecting \"java\" instead.");
        }
        Collection collection = JRVerifier.verifyDesign(jasperDesign);
        if (collection != null && collection.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Report design not valid : ");
            int n = 1;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\n\t " + n + ". " + (String)iterator.next());
                ++n;
            }
            throw new JRException(stringBuffer.toString());
        }
        String string = JRBshGenerator.generateScript(jasperDesign);
        boolean bl = JRProperties.getBooleanProperty("net.sf.jasperreports.compiler.keep.java.file");
        if (bl) {
            String string2 = JRProperties.getProperty("net.sf.jasperreports.compiler.temp.dir");
            File file = new File(string2);
            if (!file.exists() || !file.isDirectory()) {
                throw new JRException("Temporary directory not found : " + string2);
            }
            File file2 = new File(file, jasperDesign.getName() + ".bsh");
            JRSaver.saveClassSource(string, file2);
        }
        jasperReport = new JasperReport(jasperDesign, this.getClass().getName(), string);
        this.verifyScript(jasperDesign, string);
        return jasperReport;
    }

    private void verifyScript(JasperDesign jasperDesign, String string) throws JRException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass(JRCalculator.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classLoader = this.getClass().getClassLoader();
        }
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        JRBshCalculator jRBshCalculator = new JRBshCalculator(string);
        jRBshCalculator.verify(jasperDesign.getExpressions());
        Thread.currentThread().setContextClassLoader(classLoader2);
    }

    public JRCalculator loadCalculator(JasperReport jasperReport) throws JRException {
        return new JRBshCalculator((String)jasperReport.getCompileData());
    }
}

