/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * atan(vec3(0.0, 0.0, 0.0), vec3(1e-10, -1e-10, 0.1)) => vec3(0.0, 3.1415927, 0.0)
 * atan(vec3(0.0, 0.0, 0.0), vec3(-0.1, 1.0, -1.0)) => vec3(3.1415927, 0.0, 3.1415927)
 * atan(vec3(0.0, 0.0, 0.0), vec3(10.0, -10.0, 1e+10)) => vec3(0.0, 3.1415927, 0.0)
 * atan(vec3(0.0, 1e-10, 1e-10), vec3(-1e+10, 0.0, 1e-10)) => vec3(3.1415927, 1.5707964, 0.78539819)
 * atan(vec3(1e-10, 1e-10, 1e-10), vec3(-1e-10, 0.1, -0.1)) => vec3(2.3561945, 9.9999997e-10, 3.1415927)
 * atan(vec3(1e-10, 1e-10, 1e-10), vec3(1.0, -1.0, 10.0)) => vec3(1e-10, 3.1415927, 1e-11)
 * atan(vec3(1e-10, 1e-10, 1e-10), vec3(-10.0, 1e+10, -1e+10)) => vec3(3.1415927, 1e-20, 3.1415927)
 * atan(vec3(-1e-10, -1e-10, -1e-10), vec3(0.0, 1e-10, -1e-10)) => vec3(-1.5707964, -0.78539819, -2.3561945)
 * atan(vec3(-1e-10, -1e-10, -1e-10), vec3(0.1, -0.1, 1.0)) => vec3(-9.9999997e-10, -3.1415927, -1e-10)
 * atan(vec3(-1e-10, -1e-10, -1e-10), vec3(-1.0, 10.0, -10.0)) => vec3(-3.1415927, -1e-11, -3.1415927)
 * atan(vec3(-1e-10, -1e-10, 0.1), vec3(1e+10, -1e+10, 0.0)) => vec3(-1e-20, -3.1415927, 1.5707964)
 * atan(vec3(0.1, 0.1, 0.1), vec3(1e-10, -1e-10, 0.1)) => vec3(1.5707964, 1.5707964, 0.78539819)
 * atan(vec3(0.1, 0.1, 0.1), vec3(-0.1, 1.0, -1.0)) => vec3(2.3561945, 0.099668652, 3.041924)
 * atan(vec3(0.1, 0.1, 0.1), vec3(10.0, -10.0, 1e+10)) => vec3(0.0099996673, 3.131593, 1e-11)
 * atan(vec3(0.1, -0.1, -0.1), vec3(-1e+10, 0.0, 1e-10)) => vec3(3.1415927, -1.5707964, -1.5707964)
 * atan(vec3(-0.1, -0.1, -0.1), vec3(-1e-10, 0.1, -0.1)) => vec3(-1.5707964, -0.78539819, -2.3561945)
 * atan(vec3(-0.1, -0.1, -0.1), vec3(1.0, -1.0, 10.0)) => vec3(-0.099668652, -3.041924, -0.0099996673)
 * atan(vec3(-0.1, -0.1, -0.1), vec3(-10.0, 1e+10, -1e+10)) => vec3(-3.131593, -1e-11, -3.1415927)
 * atan(vec3(1.0, 1.0, 1.0), vec3(0.0, 1e-10, -1e-10)) => vec3(1.5707964, 1.5707964, 1.5707964)
 * atan(vec3(1.0, 1.0, 1.0), vec3(0.1, -0.1, 1.0)) => vec3(1.4711276, 1.670465, 0.78539819)
 * atan(vec3(1.0, 1.0, 1.0), vec3(-1.0, 10.0, -10.0)) => vec3(2.3561945, 0.099668652, 3.041924)
 * atan(vec3(1.0, 1.0, -1.0), vec3(1e+10, -1e+10, 0.0)) => vec3(1e-10, 3.1415927, -1.5707964)
 * atan(vec3(-1.0, -1.0, -1.0), vec3(1e-10, -1e-10, 0.1)) => vec3(-1.5707964, -1.5707964, -1.4711276)
 * atan(vec3(-1.0, -1.0, -1.0), vec3(-0.1, 1.0, -1.0)) => vec3(-1.670465, -0.78539819, -2.3561945)
 * atan(vec3(-1.0, -1.0, -1.0), vec3(10.0, -10.0, 1e+10)) => vec3(-0.099668652, -3.041924, -1e-10)
 * atan(vec3(-1.0, 10.0, 10.0), vec3(-1e+10, 0.0, 1e-10)) => vec3(-3.1415927, 1.5707964, 1.5707964)
 * atan(vec3(10.0, 10.0, 10.0), vec3(-1e-10, 0.1, -0.1)) => vec3(1.5707964, 1.5607966, 1.580796)
 * atan(vec3(10.0, 10.0, 10.0), vec3(1.0, -1.0, 10.0)) => vec3(1.4711276, 1.670465, 0.78539819)
 * atan(vec3(10.0, 10.0, 10.0), vec3(-10.0, 1e+10, -1e+10)) => vec3(2.3561945, 9.9999997e-10, 3.1415927)
 * atan(vec3(-10.0, -10.0, -10.0), vec3(0.0, 1e-10, -1e-10)) => vec3(-1.5707964, -1.5707964, -1.5707964)
 * atan(vec3(-10.0, -10.0, -10.0), vec3(0.1, -0.1, 1.0)) => vec3(-1.5607966, -1.580796, -1.4711276)
 * atan(vec3(-10.0, -10.0, -10.0), vec3(-1.0, 10.0, -10.0)) => vec3(-1.670465, -0.78539819, -2.3561945)
 * atan(vec3(-10.0, -10.0, 1e+10), vec3(1e+10, -1e+10, 0.0)) => vec3(-9.9999997e-10, -3.1415927, 1.5707964)
 * atan(vec3(1e+10, 1e+10, 1e+10), vec3(1e-10, -1e-10, 0.1)) => vec3(1.5707964, 1.5707964, 1.5707964)
 * atan(vec3(1e+10, 1e+10, 1e+10), vec3(-0.1, 1.0, -1.0)) => vec3(1.5707964, 1.5707964, 1.5707964)
 * atan(vec3(1e+10, 1e+10, 1e+10), vec3(10.0, -10.0, 1e+10)) => vec3(1.5707964, 1.5707964, 0.78539819)
 * atan(vec3(1e+10, -1e+10, -1e+10), vec3(-1e+10, 0.0, 1e-10)) => vec3(2.3561945, -1.5707964, -1.5707964)
 * atan(vec3(-1e+10, -1e+10, -1e+10), vec3(-1e-10, 0.1, -0.1)) => vec3(-1.5707964, -1.5707964, -1.5707964)
 * atan(vec3(-1e+10, -1e+10, -1e+10), vec3(1.0, -1.0, 10.0)) => vec3(-1.5707964, -1.5707964, -1.5707964)
 * atan(vec3(-1e+10, -1e+10, -1e+10), vec3(-10.0, 1e+10, -1e+10)) => vec3(-1.5707964, -0.78539819, -2.3561945)
 */
#version 150

void main()
{
  float[distance(atan(vec3(0.0, 0.0, 0.0), vec3(1e-10, -1e-10, 0.1)), vec3(0.0, 3.1415927, 0.0)) <= 0.0031447744 ? 1 : -1] array0;
  float[distance(atan(vec3(0.0, 0.0, 0.0), vec3(-0.1, 1.0, -1.0)), vec3(3.1415927, 0.0, 3.1415927)) <= 0.0044440082 ? 1 : -1] array1;
  float[distance(atan(vec3(0.0, 0.0, 0.0), vec3(10.0, -10.0, 1e+10)), vec3(0.0, 3.1415927, 0.0)) <= 0.0031447744 ? 1 : -1] array2;
  float[distance(atan(vec3(0.0, 1e-10, 1e-10), vec3(-1e+10, 0.0, 1e-10)), vec3(3.1415927, 1.5707964, 0.78539819)) <= 0.0035991466 ? 1 : -1] array3;
  float[distance(atan(vec3(1e-10, 1e-10, 1e-10), vec3(-1e-10, 0.1, -0.1)), vec3(2.3561945, 9.9999997e-10, 3.1415927)) <= 0.0039282637 ? 1 : -1] array4;
  float[distance(atan(vec3(1e-10, 1e-10, 1e-10), vec3(1.0, -1.0, 10.0)), vec3(1e-10, 3.1415927, 1e-11)) <= 0.0031447744 ? 1 : -1] array5;
  float[distance(atan(vec3(1e-10, 1e-10, 1e-10), vec3(-10.0, 1e+10, -1e+10)), vec3(3.1415927, 1e-20, 3.1415927)) <= 0.0044440082 ? 1 : -1] array6;
  float[distance(atan(vec3(-1e-10, -1e-10, -1e-10), vec3(0.0, 1e-10, -1e-10)), vec3(-1.5707964, -0.78539819, -2.3561945)) <= 0.0029386908 ? 1 : -1] array7;
  float[distance(atan(vec3(-1e-10, -1e-10, -1e-10), vec3(0.1, -0.1, 1.0)), vec3(-9.9999997e-10, -3.1415927, -1e-10)) <= 0.0031447744 ? 1 : -1] array8;
  float[distance(atan(vec3(-1e-10, -1e-10, -1e-10), vec3(-1.0, 10.0, -10.0)), vec3(-3.1415927, -1e-11, -3.1415927)) <= 0.0044440082 ? 1 : -1] array9;
  float[distance(atan(vec3(-1e-10, -1e-10, 0.1), vec3(1e+10, -1e+10, 0.0)), vec3(-1e-20, -3.1415927, 1.5707964)) <= 0.0035138307 ? 1 : -1] array10;
  float[distance(atan(vec3(0.1, 0.1, 0.1), vec3(1e-10, -1e-10, 0.1)), vec3(1.5707964, 1.5707964, 0.78539819)) <= 0.0023561944 ? 1 : -1] array11;
  float[distance(atan(vec3(0.1, 0.1, 0.1), vec3(-0.1, 1.0, -1.0)), vec3(2.3561945, 0.099668652, 3.041924)) <= 0.0038490198 ? 1 : -1] array12;
  float[distance(atan(vec3(0.1, 0.1, 0.1), vec3(10.0, -10.0, 1e+10)), vec3(0.0099996673, 3.131593, 1e-11)) <= 0.0031347845 ? 1 : -1] array13;
  float[distance(atan(vec3(0.1, -0.1, -0.1), vec3(-1e+10, 0.0, 1e-10)), vec3(3.1415927, -1.5707964, -1.5707964)) <= 0.0038476496 ? 1 : -1] array14;
  float[distance(atan(vec3(-0.1, -0.1, -0.1), vec3(-1e-10, 0.1, -0.1)), vec3(-1.5707964, -0.78539819, -2.3561945)) <= 0.0029386908 ? 1 : -1] array15;
  float[distance(atan(vec3(-0.1, -0.1, -0.1), vec3(1.0, -1.0, 10.0)), vec3(-0.099668652, -3.041924, -0.0099996673)) <= 0.0030452097 ? 1 : -1] array16;
  float[distance(atan(vec3(-0.1, -0.1, -0.1), vec3(-10.0, 1e+10, -1e+10)), vec3(-3.131593, -1e-11, -3.1415927)) <= 0.0044369446 ? 1 : -1] array17;
  float[distance(atan(vec3(1.0, 1.0, 1.0), vec3(0.0, 1e-10, -1e-10)), vec3(1.5707964, 1.5707964, 1.5707964)) <= 0.0027206992 ? 1 : -1] array18;
  float[distance(atan(vec3(1.0, 1.0, 1.0), vec3(0.1, -0.1, 1.0)), vec3(1.4711276, 1.670465, 0.78539819)) <= 0.0023604068 ? 1 : -1] array19;
  float[distance(atan(vec3(1.0, 1.0, 1.0), vec3(-1.0, 10.0, -10.0)), vec3(2.3561945, 0.099668652, 3.041924)) <= 0.0038490198 ? 1 : -1] array20;
  float[distance(atan(vec3(1.0, 1.0, -1.0), vec3(1e+10, -1e+10, 0.0)), vec3(1e-10, 3.1415927, -1.5707964)) <= 0.0035138307 ? 1 : -1] array21;
  float[distance(atan(vec3(-1.0, -1.0, -1.0), vec3(1e-10, -1e-10, 0.1)), vec3(-1.5707964, -1.5707964, -1.4711276)) <= 0.0026643984 ? 1 : -1] array22;
  float[distance(atan(vec3(-1.0, -1.0, -1.0), vec3(-0.1, 1.0, -1.0)), vec3(-1.670465, -0.78539819, -2.3561945)) <= 0.0029931515 ? 1 : -1] array23;
  float[distance(atan(vec3(-1.0, -1.0, -1.0), vec3(10.0, -10.0, 1e+10)), vec3(-0.099668652, -3.041924, -1e-10)) <= 0.0030452097 ? 1 : -1] array24;
  float[distance(atan(vec3(-1.0, 10.0, 10.0), vec3(-1e+10, 0.0, 1e-10)), vec3(-3.1415927, 1.5707964, 1.5707964)) <= 0.0038476496 ? 1 : -1] array25;
  float[distance(atan(vec3(10.0, 10.0, 10.0), vec3(-1e-10, 0.1, -0.1)), vec3(1.5707964, 1.5607966, 1.580796)) <= 0.0027207357 ? 1 : -1] array26;
  float[distance(atan(vec3(10.0, 10.0, 10.0), vec3(1.0, -1.0, 10.0)), vec3(1.4711276, 1.670465, 0.78539819)) <= 0.0023604068 ? 1 : -1] array27;
  float[distance(atan(vec3(10.0, 10.0, 10.0), vec3(-10.0, 1e+10, -1e+10)), vec3(2.3561945, 9.9999997e-10, 3.1415927)) <= 0.0039282637 ? 1 : -1] array28;
  float[distance(atan(vec3(-10.0, -10.0, -10.0), vec3(0.0, 1e-10, -1e-10)), vec3(-1.5707964, -1.5707964, -1.5707964)) <= 0.0027206992 ? 1 : -1] array29;
  float[distance(atan(vec3(-10.0, -10.0, -10.0), vec3(0.1, -0.1, 1.0)), vec3(-1.5607966, -1.580796, -1.4711276)) <= 0.0026644359 ? 1 : -1] array30;
  float[distance(atan(vec3(-10.0, -10.0, -10.0), vec3(-1.0, 10.0, -10.0)), vec3(-1.670465, -0.78539819, -2.3561945)) <= 0.0029931515 ? 1 : -1] array31;
  float[distance(atan(vec3(-10.0, -10.0, 1e+10), vec3(1e+10, -1e+10, 0.0)), vec3(-9.9999997e-10, -3.1415927, 1.5707964)) <= 0.0035138307 ? 1 : -1] array32;
  float[distance(atan(vec3(1e+10, 1e+10, 1e+10), vec3(1e-10, -1e-10, 0.1)), vec3(1.5707964, 1.5707964, 1.5707964)) <= 0.0027206992 ? 1 : -1] array33;
  float[distance(atan(vec3(1e+10, 1e+10, 1e+10), vec3(-0.1, 1.0, -1.0)), vec3(1.5707964, 1.5707964, 1.5707964)) <= 0.0027206992 ? 1 : -1] array34;
  float[distance(atan(vec3(1e+10, 1e+10, 1e+10), vec3(10.0, -10.0, 1e+10)), vec3(1.5707964, 1.5707964, 0.78539819)) <= 0.0023561944 ? 1 : -1] array35;
  float[distance(atan(vec3(1e+10, -1e+10, -1e+10), vec3(-1e+10, 0.0, 1e-10)), vec3(2.3561945, -1.5707964, -1.5707964)) <= 0.0032382796 ? 1 : -1] array36;
  float[distance(atan(vec3(-1e+10, -1e+10, -1e+10), vec3(-1e-10, 0.1, -0.1)), vec3(-1.5707964, -1.5707964, -1.5707964)) <= 0.0027206992 ? 1 : -1] array37;
  float[distance(atan(vec3(-1e+10, -1e+10, -1e+10), vec3(1.0, -1.0, 10.0)), vec3(-1.5707964, -1.5707964, -1.5707964)) <= 0.0027206992 ? 1 : -1] array38;
  float[distance(atan(vec3(-1e+10, -1e+10, -1e+10), vec3(-10.0, 1e+10, -1e+10)), vec3(-1.5707964, -0.78539819, -2.3561945)) <= 0.0029386908 ? 1 : -1] array39;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length() + array27.length() + array28.length() + array29.length() + array30.length() + array31.length() + array32.length() + array33.length() + array34.length() + array35.length() + array36.length() + array37.length() + array38.length() + array39.length());
}
