/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * dot(vec2(-0.1, -1.2), vec2(-0.1, -1.2)) => 1.4500002
 * dot(vec2(-0.1, -1.2), vec2(-0.41999999, 0.47999999)) => -0.53400004
 * dot(vec2(-0.41999999, 0.47999999), vec2(-0.1, -1.2)) => -0.53400004
 * dot(vec2(-0.41999999, 0.47999999), vec2(-0.41999999, 0.47999999)) => 0.40679997
 */
#version 120

void main()
{
  float[distance(dot(vec2(-0.1, -1.2), vec2(-0.1, -1.2)), 1.4500002) <= 1.4500001e-05 ? 1 : -1] array0;
  float[distance(dot(vec2(-0.1, -1.2), vec2(-0.41999999, 0.47999999)), -0.53400004) <= 5.3399999e-06 ? 1 : -1] array1;
  float[distance(dot(vec2(-0.41999999, 0.47999999), vec2(-0.1, -1.2)), -0.53400004) <= 5.3399999e-06 ? 1 : -1] array2;
  float[distance(dot(vec2(-0.41999999, 0.47999999), vec2(-0.41999999, 0.47999999)), 0.40679997) <= 4.0679997e-06 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
