/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * round(-2.0lf) => -2.0lf
 * round(-1.4285714285714286lf) => -1.0lf
 * round(-0.85714285714285721lf) => -1.0lf
 * round(-0.28571428571428581lf) => -0.0lf
 * round(0.28571428571428559lf) => 0.0lf
 * round(0.85714285714285676lf) => 1.0lf
 * round(1.4285714285714284lf) => 1.0lf
 * round(2.0lf) => 2.0lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(round(-2.0lf), -2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array0;
  double[distance(round(-1.4285714285714286lf), -1.0lf) <= 1.0000000000000001e-05lf ? 1 : -1] array1;
  double[distance(round(-0.85714285714285721lf), -1.0lf) <= 1.0000000000000001e-05lf ? 1 : -1] array2;
  double[distance(round(-0.28571428571428581lf), -0.0lf) <= 0.0lf ? 1 : -1] array3;
  double[distance(round(0.28571428571428559lf), 0.0lf) <= 0.0lf ? 1 : -1] array4;
  double[distance(round(0.85714285714285676lf), 1.0lf) <= 1.0000000000000001e-05lf ? 1 : -1] array5;
  double[distance(round(1.4285714285714284lf), 1.0lf) <= 1.0000000000000001e-05lf ? 1 : -1] array6;
  double[distance(round(2.0lf), 2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
