/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * reflect(dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf), dvec3(-0.72482205962243695lf, -0.46207406300930359lf, -0.51099955203381808lf)) => dvec3(1.3333333333333337lf, 0.8500000000000002lf, 0.94000000000000017lf)
 * reflect(dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf), dvec3(0.64414939069124011lf, 0.25457401069234642lf, 0.72129303029498149lf)) => dvec3(0.92540125569077847lf, 0.042673550153241813lf, 1.5892417254341851lf)
 * reflect(dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf), dvec3(-0.72482205962243695lf, -0.46207406300930359lf, -0.51099955203381808lf)) => dvec3(-1.9120574029138178lf, -1.6235615943575588lf, -0.65535046905424155lf)
 * reflect(dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf), dvec3(0.64414939069124011lf, 0.25457401069234642lf, 0.72129303029498149lf)) => dvec3(-1.6699999999999999lf, -0.66000000000000003lf, -1.8699999999999997lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(reflect(dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf), dvec3(-0.72482205962243695lf, -0.46207406300930359lf, -0.51099955203381808lf)), dvec3(1.3333333333333337lf, 0.8500000000000002lf, 0.94000000000000017lf)) <= 1.8395319452996136e-05lf ? 1 : -1] array0;
  double[distance(reflect(dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf), dvec3(0.64414939069124011lf, 0.25457401069234642lf, 0.72129303029498149lf)), dvec3(0.92540125569077847lf, 0.042673550153241813lf, 1.5892417254341851lf)) <= 1.8395319452996126e-05lf ? 1 : -1] array1;
  double[distance(reflect(dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf), dvec3(-0.72482205962243695lf, -0.46207406300930359lf, -0.51099955203381808lf)), dvec3(-1.9120574029138178lf, -1.6235615943575588lf, -0.65535046905424155lf)) <= 2.5925662961629367e-05lf ? 1 : -1] array2;
  double[distance(reflect(dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf), dvec3(0.64414939069124011lf, 0.25457401069234642lf, 0.72129303029498149lf)), dvec3(-1.6699999999999999lf, -0.66000000000000003lf, -1.8699999999999997lf)) <= 2.592566296162935e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
