/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf) * 0.0lf) => dvec3(-0.0lf, -0.0lf, -0.0lf)
 * (dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf) * -1.3333333333333333lf) => dvec3(1.7777777777777777lf, 1.1333333333333333lf, 1.2533333333333332lf)
 * (dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf) * 0.84999999999999998lf) => dvec3(-1.1333333333333333lf, -0.72249999999999992lf, -0.79899999999999993lf)
 * (dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf) * 0.0lf) => dvec3(0.0lf, 0.0lf, 0.0lf)
 * (dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf) * -1.3333333333333333lf) => dvec3(-2.2266666666666666lf, -0.88lf, -2.4933333333333332lf)
 * (dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf) * 0.84999999999999998lf) => dvec3(1.4195lf, 0.56100000000000005lf, 1.5895000000000001lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf) * 0.0lf), dvec3(-0.0lf, -0.0lf, -0.0lf)) <= 0.0lf ? 1 : -1] array0;
  double[distance((dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf) * -1.3333333333333333lf), dvec3(1.7777777777777777lf, 1.1333333333333333lf, 1.2533333333333332lf)) <= 2.452709260399484e-05lf ? 1 : -1] array1;
  double[distance((dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf) * 0.84999999999999998lf), dvec3(-1.1333333333333333lf, -0.72249999999999992lf, -0.79899999999999993lf)) <= 1.5636021535046709e-05lf ? 1 : -1] array2;
  double[distance((dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf) * 0.0lf), dvec3(0.0lf, 0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array3;
  double[distance((dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf) * -1.3333333333333333lf), dvec3(-2.2266666666666666lf, -0.88lf, -2.4933333333333332lf)) <= 3.4567550615505802e-05lf ? 1 : -1] array4;
  double[distance((dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf) * 0.84999999999999998lf), dvec3(1.4195lf, 0.56100000000000005lf, 1.5895000000000001lf)) <= 2.2036813517384954e-05lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
