/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(-2.0lf, -3.0lf, 0.0lf) => -2.0lf
 * mix(-2.0lf, -3.0lf, 0.33333333333333331lf) => -2.3333333333333335lf
 * mix(-2.0lf, -3.0lf, 0.66666666666666663lf) => -2.666666666666667lf
 * mix(-2.0lf, -3.0lf, 1.0lf) => -3.0lf
 * mix(-2.0lf, 3.0lf, 0.0lf) => -2.0lf
 * mix(-2.0lf, 3.0lf, 0.33333333333333331lf) => -0.33333333333333348lf
 * mix(-2.0lf, 3.0lf, 0.66666666666666663lf) => 1.3333333333333333lf
 * mix(-2.0lf, 3.0lf, 1.0lf) => 3.0lf
 * mix(2.0lf, -3.0lf, 0.0lf) => 2.0lf
 * mix(2.0lf, -3.0lf, 0.33333333333333331lf) => 0.33333333333333348lf
 * mix(2.0lf, -3.0lf, 0.66666666666666663lf) => -1.3333333333333333lf
 * mix(2.0lf, -3.0lf, 1.0lf) => -3.0lf
 * mix(2.0lf, 3.0lf, 0.0lf) => 2.0lf
 * mix(2.0lf, 3.0lf, 0.33333333333333331lf) => 2.3333333333333335lf
 * mix(2.0lf, 3.0lf, 0.66666666666666663lf) => 2.666666666666667lf
 * mix(2.0lf, 3.0lf, 1.0lf) => 3.0lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(mix(-2.0lf, -3.0lf, 0.0lf), -2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array0;
  double[distance(mix(-2.0lf, -3.0lf, 0.33333333333333331lf), -2.3333333333333335lf) <= 2.3333333333333336e-05lf ? 1 : -1] array1;
  double[distance(mix(-2.0lf, -3.0lf, 0.66666666666666663lf), -2.666666666666667lf) <= 2.6666666666666673e-05lf ? 1 : -1] array2;
  double[distance(mix(-2.0lf, -3.0lf, 1.0lf), -3.0lf) <= 3.0000000000000004e-05lf ? 1 : -1] array3;
  double[distance(mix(-2.0lf, 3.0lf, 0.0lf), -2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array4;
  double[distance(mix(-2.0lf, 3.0lf, 0.33333333333333331lf), -0.33333333333333348lf) <= 3.333333333333335e-06lf ? 1 : -1] array5;
  double[distance(mix(-2.0lf, 3.0lf, 0.66666666666666663lf), 1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array6;
  double[distance(mix(-2.0lf, 3.0lf, 1.0lf), 3.0lf) <= 3.0000000000000004e-05lf ? 1 : -1] array7;
  double[distance(mix(2.0lf, -3.0lf, 0.0lf), 2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array8;
  double[distance(mix(2.0lf, -3.0lf, 0.33333333333333331lf), 0.33333333333333348lf) <= 3.333333333333335e-06lf ? 1 : -1] array9;
  double[distance(mix(2.0lf, -3.0lf, 0.66666666666666663lf), -1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array10;
  double[distance(mix(2.0lf, -3.0lf, 1.0lf), -3.0lf) <= 3.0000000000000004e-05lf ? 1 : -1] array11;
  double[distance(mix(2.0lf, 3.0lf, 0.0lf), 2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array12;
  double[distance(mix(2.0lf, 3.0lf, 0.33333333333333331lf), 2.3333333333333335lf) <= 2.3333333333333336e-05lf ? 1 : -1] array13;
  double[distance(mix(2.0lf, 3.0lf, 0.66666666666666663lf), 2.666666666666667lf) <= 2.6666666666666673e-05lf ? 1 : -1] array14;
  double[distance(mix(2.0lf, 3.0lf, 1.0lf), 3.0lf) <= 3.0000000000000004e-05lf ? 1 : -1] array15;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length());
}
