/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * max(dvec4(-2.0lf, -0.66666666666666674lf, 0.66666666666666652lf, 2.0lf), -2.0lf) => dvec4(-2.0lf, -0.66666666666666674lf, 0.66666666666666652lf, 2.0lf)
 * max(dvec4(-2.0lf, -0.66666666666666674lf, 0.66666666666666652lf, 2.0lf), -0.66666666666666674lf) => dvec4(-0.66666666666666674lf, -0.66666666666666674lf, 0.66666666666666652lf, 2.0lf)
 * max(dvec4(-2.0lf, -0.66666666666666674lf, 0.66666666666666652lf, 2.0lf), 0.66666666666666652lf) => dvec4(0.66666666666666652lf, 0.66666666666666652lf, 0.66666666666666652lf, 2.0lf)
 * max(dvec4(-2.0lf, -0.66666666666666674lf, 0.66666666666666652lf, 2.0lf), 2.0lf) => dvec4(2.0lf, 2.0lf, 2.0lf, 2.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(max(dvec4(-2.0lf, -0.66666666666666674lf, 0.66666666666666652lf, 2.0lf), -2.0lf), dvec4(-2.0lf, -0.66666666666666674lf, 0.66666666666666652lf, 2.0lf)) <= 2.9814239699997199e-05lf ? 1 : -1] array0;
  double[distance(max(dvec4(-2.0lf, -0.66666666666666674lf, 0.66666666666666652lf, 2.0lf), -0.66666666666666674lf), dvec4(-0.66666666666666674lf, -0.66666666666666674lf, 0.66666666666666652lf, 2.0lf)) <= 2.3094010767585035e-05lf ? 1 : -1] array1;
  double[distance(max(dvec4(-2.0lf, -0.66666666666666674lf, 0.66666666666666652lf, 2.0lf), 0.66666666666666652lf), dvec4(0.66666666666666652lf, 0.66666666666666652lf, 0.66666666666666652lf, 2.0lf)) <= 2.3094010767585031e-05lf ? 1 : -1] array2;
  double[distance(max(dvec4(-2.0lf, -0.66666666666666674lf, 0.66666666666666652lf, 2.0lf), 2.0lf), dvec4(2.0lf, 2.0lf, 2.0lf, 2.0lf)) <= 4.0000000000000003e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
