<?php

/**
 * This PHP file is the webapp auth api calls to check it's KOPANO_WEBAPP cookie
 * and to retrieve tokens
 */

include("zarafa_session.php");
include("../config.php");

$sessionid;
$user_id;
$displayname;
$type = "";

if (WebAppAuthentication::isAuthenticated()) {
	// Authenticated
	if ($_POST && array_key_exists("code", $_POST)) {
		if ($_POST['code'] == "zarafasession") {
			$sessionid = WebAppAuthentication::getMapiSession()->getSessionID();
		} else {
			$sessionid = $_POST['code'];
		}
	} else {
		$sessionid = WebAppAuthentication::getMapiSession()->getSessionID();
	}
	if ($sessionid == WebAppAuthentication::getMapiSession()->getSessionID()) {
		$type = "zarafa";
		$user_id = WebAppAuthentication::getMapiSession()->getEmailAddress();
		$displayname = WebAppAuthentication::getMapiSession()->getFullName();
	}
} 

if ($type == "zarafa") {
	// kopano session
} elseif ($_POST && array_key_exists("code", $_POST)) {
	$type = "meeting";
	$code = $_POST['code'];

	$token_secret = PLUGIN_SPREEDWEBRTC_WEBAUTH_CODE_TOKEN_SECRET;
	$token_name = 'CODE_TOKEN';

	$access_token = '';
	if ($_POST && array_key_exists("access_token", $_POST)) {
		$access_token = $_POST['access_token'];
	}
	$client_id = '';
	if ($_POST && array_key_exists("client_id", $_POST)) {
		$client_id = base64_encode($_POST['client_id']);
	}
	$client_secret = '';
	if ($_POST && array_key_exists("client_secret", $_POST)) {
		$client_secret = base64_encode($_POST['client_secret']);
	}

	$data_mac = base64_decode($code);
	$parts = explode('|', $data_mac);
	$time = $parts[0];
	$value = $parts[1];
	$mac = $parts[2];
	$time_value = $time . '|' . $value  . '|';

	if ($time < time()) {
		header('HTTP/1.1 403 Unauthorized');
		echo json_encode(array('success' => false, 'code' => 'expired'));
		exit;
	}

	if ($mac != base64_encode(hash_hmac('sha256', $token_name . '|' . $time_value, $token_secret, true))) {
		header('HTTP/1.1 403 Unauthorized');
		echo json_encode(array('success' => false, 'code' => 'failed'));
		exit;
	}

	$value_parts = explode(':', $value);
	$value_meetingid = $value_parts[0];
	$value_email = $value_parts[1];
	$value_displayname = $value_parts[2];
	$value_client_id = $value_parts[3];
	$value_client_secret = $value_parts[4];

	if ($client_id != $value_client_id && $client_secret != $value_client_secret) {
		header('HTTP/1.1 403 Unauthorized');
		echo json_encode(array('success' => false, 'code' => 'bad_client'));
		exit;
	}

	$user_id = $value_email;
	$displayname = $value_displayname;
} else {
	header('HTTP/1.1 403 Unauthorized');
	echo json_encode(array('success' => false, 'code' => 'failed'));
	exit;
}

$token_secret = PLUGIN_SPREEDWEBRTC_WEBAUTH_ACCESS_TOKEN_SECRET;
$token_name = 'ACCESS_TOKEN';

$client_id = '';
if ($_POST && array_key_exists("client_id", $_POST)) {
	$client_id = base64_encode($_POST['client_id']);
}
$client_secret = '';
if ($_POST && array_key_exists("client_secret", $_POST)) {
	$client_secret = base64_encode($_POST['client_secret']);
}
$value = $type . ':' . $sessionid . ':' . $user_id . ':' . $displayname . ':' . $client_id . ':' . $client_secret;
$time = time() + PLUGIN_SPREEDWEBRTC_WEBAUTH_ACCESS_TOKEN_EXPIRES;
$time_value = $time . '|' . $value  . '|';
$mac = base64_encode(hash_hmac('sha256', $token_name . '|' . $time_value, $token_secret, true));
$data_mac = $time_value . $mac;
$access_token = base64_encode($data_mac);

$token_response = array(
	'success' => true,
	'access_token' => $access_token,
	'token_type' => 'Bearer',
	'expires_in' => PLUGIN_SPREEDWEBRTC_WEBAUTH_ACCESS_TOKEN_EXPIRES
	, 'mac' => $mac, 'data' => $token_name . '|' . $time_value      // TODO remove
);

header("Content-Type: application/json");
header("Cache-Control: no-store");
header("Pragma: no-cache");
echo json_encode($token_response);
exit;

?>
