/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.storage.implementations;

import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SKI;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverException;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverSpi;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CertsInFilesystemDirectoryResolver
extends StorageResolverSpi {
    private static Logger log = Logger.getLogger(CertsInFilesystemDirectoryResolver.class.getName());
    private String merlinsCertificatesDir = null;
    private List<X509Certificate> certs = new ArrayList<X509Certificate>();

    public CertsInFilesystemDirectoryResolver(String string) throws StorageResolverException {
        this.merlinsCertificatesDir = string;
        this.readCertsFromHarddrive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCertsFromHarddrive() throws StorageResolverException {
        File file = new File(this.merlinsCertificatesDir);
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.endsWith(".crt")) continue;
            arrayList.add(stringArray[i]);
        }
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new StorageResolverException("empty", certificateException);
        }
        if (certificateFactory == null) {
            throw new StorageResolverException("empty");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = file.getAbsolutePath() + File.separator + (String)arrayList.get(i);
            File file2 = new File(string);
            boolean bl = false;
            String string2 = null;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
                x509Certificate.checkValidity();
                this.certs.add(x509Certificate);
                string2 = x509Certificate.getSubjectX500Principal().getName();
                bl = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Could not add certificate from file " + string, fileNotFoundException);
                }
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Could not add certificate from file " + string, certificateNotYetValidException);
                }
            }
            catch (CertificateExpiredException certificateExpiredException) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Could not add certificate from file " + string, certificateExpiredException);
                }
            }
            catch (CertificateException certificateException) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Could not add certificate from file " + string, certificateException);
                }
            }
            finally {
                block34: {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!log.isLoggable(Level.FINE)) break block34;
                        log.log(Level.FINE, "Could not add certificate from file " + string, iOException);
                    }
                }
            }
            if (!bl || !log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Added certificate: " + string2);
        }
    }

    @Override
    public Iterator<Certificate> getIterator() {
        return new FilesystemIterator(this.certs);
    }

    public static void main(String[] stringArray) throws Exception {
        CertsInFilesystemDirectoryResolver certsInFilesystemDirectoryResolver = new CertsInFilesystemDirectoryResolver("data/ie/baltimore/merlin-examples/merlin-xmldsig-eighteen/certs");
        Iterator<Certificate> iterator = certsInFilesystemDirectoryResolver.getIterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            byte[] byArray = XMLX509SKI.getSKIBytesFromCert(x509Certificate);
            System.out.println();
            System.out.println("Base64(SKI())=                 \"" + Base64.encode(byArray) + "\"");
            System.out.println("cert.getSerialNumber()=        \"" + x509Certificate.getSerialNumber().toString() + "\"");
            System.out.println("cert.getSubjectX500Principal().getName()= \"" + x509Certificate.getSubjectX500Principal().getName() + "\"");
            System.out.println("cert.getIssuerX500Principal().getName()=  \"" + x509Certificate.getIssuerX500Principal().getName() + "\"");
        }
    }

    private static class FilesystemIterator
    implements Iterator<Certificate> {
        List<X509Certificate> certs = null;
        int i;

        public FilesystemIterator(List<X509Certificate> list) {
            this.certs = list;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.certs.size();
        }

        @Override
        public Certificate next() {
            return this.certs.get(this.i++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

