/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.validator;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.MultipleNameVisitor;
import org.openstreetmap.josm.tools.ImageProvider;

public class ValidatorTreeRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object nodeInfo = node.getUserObject();
        if (nodeInfo instanceof Severity) {
            Severity s = (Severity)((Object)nodeInfo);
            this.setIcon(ImageProvider.get("data", s.getIcon()));
        } else if (nodeInfo instanceof TestError) {
            TestError error = (TestError)nodeInfo;
            MultipleNameVisitor v = new MultipleNameVisitor();
            v.visit(error.getPrimitives());
            this.setText(v.getText());
            this.setIcon(v.getIcon());
        }
        return this;
    }
}

