#!/bin/sh
export PATH='/usr/obj/ports/hs-dbus-0.10.13/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: dbus
version: 0.10.13
id: dbus-0.10.13-IUelLsOGWpyBGcXH63C8d4
key: dbus-0.10.13-IUelLsOGWpyBGcXH63C8d4
license: GPL-3
maintainer: Andrey Sverdlichenko <blaze@ruddy.ru>, John Millikin <john@john-millikin.com>
stability: experimental
homepage: https://github.com/rblaze/haskell-dbus#readme
synopsis: A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.
    .
    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.
    .
    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.
    .
    Example: connect to the session bus, and get a list of active names.
    .
    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
    .
    import Data.List (sort)
    import DBus
    import DBus.Client
    .
    main = do
    &#x20;   client <- connectSession
    &#x20;   //
    &#x20;   \-- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;   //
    &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   \-- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;   //
    &#x20;   \-- Print each name on a line, sorted so reserved names are below
    &#x20;   \-- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @
    .
    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <john@john-millikin.com>
exposed: True
indefinite: False
exposed-modules:
    DBus DBus.Client DBus.Internal.Address DBus.Internal.Message
    DBus.Internal.Types DBus.Internal.Wire DBus.Introspection
    DBus.Socket DBus.Transport
abi: 7fea9ef5a58786f8104bdb5468119465
trusted: False
import-dirs: /usr/local/lib/ghc/dbus-0.10.13
library-dirs: /usr/local/lib/ghc/dbus-0.10.13
              /usr/local/lib/i386-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-dbus-0.10.13
hs-libraries: HSdbus-0.10.13-IUelLsOGWpyBGcXH63C8d4
depends:
    base-4.10.1.0 bytestring-0.10.8.2
    cereal-0.4.1.0-J7JNgMSSYgsLRU6KWtlHY0 containers-0.5.10.2
    libxml-sax-0.7.5-CWwwLs2Cpr07R9NPn064CX
    network-2.6.2.1-EN7QebdZTnQLy4O4vi1CmV
    parsec-3.1.9-444fzLM2idQ5vByZuGIOJ
    random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We
    text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ transformers-0.5.2.0
    unix-2.7.2.2 vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4
    xml-types-0.3.6-KBWVauU3pnf3clHxqFFRXL
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             bytestring-0.10.8.2=3f834c69e2158c4ad5032b0346c29480
             cereal-0.4.1.0-J7JNgMSSYgsLRU6KWtlHY0=1033285ec206c99e1643a2fa74b567ef
             containers-0.5.10.2=a2c92baf4a812b005ca4fa7f0772cd30
             libxml-sax-0.7.5-CWwwLs2Cpr07R9NPn064CX=83701828a4db1d0714c2ed7a8494e31d
             network-2.6.2.1-EN7QebdZTnQLy4O4vi1CmV=8851adc1c0835b2434fe123b5bcd5394
             parsec-3.1.9-444fzLM2idQ5vByZuGIOJ=7e464826ac815eee6510ec2a536780a9
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=079775dbbb7035e99fa63cf766329cec
             text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ=5ca4db1764ff5f5e0d9e99e51b5e0b7d
             transformers-0.5.2.0=650a984849062cc36a998e6c890bf69a
             unix-2.7.2.2=fdb14956a5b19c6bc5b505e3d2c05085
             vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4=e7e504497bf3603a09d1b2efc5f2260c
             xml-types-0.3.6-KBWVauU3pnf3clHxqFFRXL=a0ed3d3b1fdc6ccfb0510731b1320087
haddock-interfaces: /usr/local/share/doc/hs-dbus-0.10.13/html/dbus.haddock
haddock-html: /usr/local/share/doc/hs-dbus-0.10.13/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

