/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc.expr;

import gnu.classpath.tools.gjdoc.expr.ConstantExpression;
import gnu.classpath.tools.gjdoc.expr.Type;

class ConstantChar
extends ConstantExpression {
    private char value;

    public ConstantChar(String stringValue) {
        this.value = stringValue.charAt(1);
        if (this.value == '\\') {
            switch (stringValue.charAt(2)) {
                case 'n': {
                    this.value = (char)10;
                    break;
                }
                case 't': {
                    this.value = (char)9;
                    break;
                }
                case 'f': {
                    this.value = (char)12;
                    break;
                }
                case 'r': {
                    this.value = (char)13;
                    break;
                }
                case 'b': {
                    this.value = (char)8;
                    break;
                }
                case 'u': {
                    String stringVal = stringValue.substring(3, stringValue.length() - 1);
                    this.value = (char)Integer.parseInt(stringVal, 16);
                }
            }
        }
    }

    public ConstantChar(char charValue) {
        this.value = charValue;
    }

    public Type getType() {
        return Type.CHAR;
    }

    public Number asNumber() {
        return new Integer(this.value);
    }

    public Object asObject() {
        return new Character(this.value);
    }

    public boolean isNumber() {
        return true;
    }

    public String toString() {
        return Character.toString(this.value);
    }
}

