/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.Serializable;

public abstract class ColorSpace
implements Serializable {
    private static final long serialVersionUID = -409452704308689724L;
    public static final int TYPE_XYZ = 0;
    public static final int TYPE_Lab = 1;
    public static final int TYPE_Luv = 2;
    public static final int TYPE_YCbCr = 3;
    public static final int TYPE_Yxy = 4;
    public static final int TYPE_RGB = 5;
    public static final int TYPE_GRAY = 6;
    public static final int TYPE_HSV = 7;
    public static final int TYPE_HLS = 8;
    public static final int TYPE_CMYK = 9;
    public static final int TYPE_CMY = 11;
    public static final int TYPE_2CLR = 12;
    public static final int TYPE_3CLR = 13;
    public static final int TYPE_4CLR = 14;
    public static final int TYPE_5CLR = 15;
    public static final int TYPE_6CLR = 16;
    public static final int TYPE_7CLR = 17;
    public static final int TYPE_8CLR = 18;
    public static final int TYPE_9CLR = 19;
    public static final int TYPE_ACLR = 20;
    public static final int TYPE_BCLR = 21;
    public static final int TYPE_CCLR = 22;
    public static final int TYPE_DCLR = 23;
    public static final int TYPE_ECLR = 24;
    public static final int TYPE_FCLR = 25;
    public static final int CS_sRGB = 1000;
    public static final int CS_LINEAR_RGB = 1004;
    public static final int CS_CIEXYZ = 1001;
    public static final int CS_PYCC = 1002;
    public static final int CS_GRAY = 1003;
    private static final int CS_BASE = 1000;
    private static final int CS_END = 1005;
    private static final int CS_COUNT = 5;
    private static final ColorSpace[] INSTANCES = new ColorSpace[5];
    final int type;
    final int numComponents;

    protected ColorSpace(int type, int numcomponents) {
        this.type = type;
        this.numComponents = numcomponents;
    }

    public static ColorSpace getInstance(int colorspace) {
        if (colorspace >= 1000 && colorspace < 1005) {
            int instanceIndex = colorspace - 1000;
            if (INSTANCES[instanceIndex] == null) {
                ICC_Profile profile = new ICC_Profile(colorspace);
                ColorSpace.INSTANCES[instanceIndex] = new ICC_ColorSpace(profile);
            }
            return INSTANCES[instanceIndex];
        }
        throw new IllegalArgumentException("unknown/unsupported colorspace");
    }

    public boolean isCS_sRGB() {
        return this.type == 1000;
    }

    public abstract float[] toRGB(float[] var1);

    public abstract float[] fromRGB(float[] var1);

    public abstract float[] toCIEXYZ(float[] var1);

    public abstract float[] fromCIEXYZ(float[] var1);

    public int getType() {
        return this.type;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public String getName(int idx) {
        return "type " + this.type;
    }

    public float getMinValue(int idx) {
        if (idx < 0 || idx >= this.numComponents) {
            throw new IllegalArgumentException();
        }
        return 0.0f;
    }

    public float getMaxValue(int idx) {
        if (idx < 0 || idx >= this.numComponents) {
            throw new IllegalArgumentException();
        }
        return 1.0f;
    }
}

