/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.key.IKeyPairGenerator;
import gnu.java.security.util.PRNG;
import gnu.javax.crypto.key.dh.GnuDHPrivateKey;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import gnu.javax.crypto.key.dh.RFC2631;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import java.util.logging.Logger;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class GnuDHKeyPairGenerator
implements IKeyPairGenerator {
    private static final Logger log = null;
    public static final String SOURCE_OF_RANDOMNESS = "gnu.crypto.dh.prng";
    public static final String DH_PARAMETERS = "gnu.crypto.dh.params";
    public static final String PRIME_SIZE = "gnu.crypto.dh.L";
    public static final String EXPONENT_SIZE = "gnu.crypto.dh.m";
    public static final String PREFERRED_ENCODING_FORMAT = "gnu.crypto.dh.encoding";
    public static final int DEFAULT_PRIME_SIZE = 512;
    public static final int DEFAULT_EXPONENT_SIZE = 160;
    private static final int DEFAULT_ENCODING_FORMAT = 1;
    private SecureRandom rnd;
    private int l;
    private int m;
    private BigInteger seed;
    private BigInteger counter;
    private BigInteger q;
    private BigInteger p;
    private BigInteger j;
    private BigInteger g;
    private PRNG prng = null;
    private int preferredFormat;

    public String name() {
        return "dh";
    }

    public void setup(Map attributes) {
        AlgorithmParameterSpec jceSpec;
        this.rnd = (SecureRandom)attributes.get(SOURCE_OF_RANDOMNESS);
        Object params = attributes.get(DH_PARAMETERS);
        if (params instanceof DHGenParameterSpec) {
            jceSpec = (DHGenParameterSpec)params;
            this.l = ((DHGenParameterSpec)jceSpec).getPrimeSize();
            this.m = ((DHGenParameterSpec)jceSpec).getExponentSize();
        } else if (params instanceof DHParameterSpec) {
            jceSpec = (DHParameterSpec)params;
            this.p = ((DHParameterSpec)jceSpec).getP();
            this.g = ((DHParameterSpec)jceSpec).getG();
            this.l = this.p.bitLength();
            this.m = ((DHParameterSpec)jceSpec).getL();
            if (this.m == 0) {
                this.m = this.l;
            }
        } else {
            Integer bi = (Integer)attributes.get(PRIME_SIZE);
            this.l = bi == null ? 512 : bi;
            bi = (Integer)attributes.get(EXPONENT_SIZE);
            int n = this.m = bi == null ? 160 : bi;
        }
        if (this.l % 256 != 0 || this.l < 512) {
            throw new IllegalArgumentException("invalid modulus size");
        }
        if (this.m % 8 != 0 || this.m < 160) {
            throw new IllegalArgumentException("invalid exponent size");
        }
        if (this.m > this.l) {
            throw new IllegalArgumentException("exponent size > modulus size");
        }
        Integer formatID = (Integer)attributes.get(PREFERRED_ENCODING_FORMAT);
        this.preferredFormat = formatID == null ? 1 : formatID;
    }

    public KeyPair generate() {
        BigInteger x;
        if (this.p == null) {
            BigInteger[] params = new RFC2631(this.m, this.l, this.rnd).generateParameters();
            this.seed = params[0];
            this.counter = params[1];
            this.q = params[2];
            this.p = params[3];
            this.j = params[4];
            this.g = params[5];
        }
        BigInteger q_minus_1 = null;
        if (this.q != null) {
            q_minus_1 = this.q.subtract(BigInteger.ONE);
        }
        byte[] mag = new byte[(this.m + 7) / 8];
        do {
            this.nextRandomBytes(mag);
        } while ((x = new BigInteger(1, mag)).bitLength() != this.m || x.compareTo(BigInteger.ONE) <= 0 || q_minus_1 != null && x.compareTo(q_minus_1) >= 0);
        BigInteger y = this.g.modPow(x, this.p);
        GnuDHPrivateKey secK = new GnuDHPrivateKey(this.preferredFormat, this.q, this.p, this.g, x);
        GnuDHPublicKey pubK = new GnuDHPublicKey(this.preferredFormat, this.q, this.p, this.g, y);
        return new KeyPair(pubK, secK);
    }

    private void nextRandomBytes(byte[] buffer) {
        if (this.rnd != null) {
            this.rnd.nextBytes(buffer);
        } else {
            this.getDefaultPRNG().nextBytes(buffer);
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

