/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.test.dsig.TestUtils;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class DigestMethodTest
extends TestCase {
    private XMLSignatureFactory factory;
    private static final String[] MD_ALGOS = new String[]{"http://www.w3.org/2000/09/xmldsig#sha1"};

    public DigestMethodTest() {
        super("DigestMethodTest");
    }

    public DigestMethodTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.factory = XMLSignatureFactory.getInstance("DOM", new XMLDSigRI());
    }

    public void tearDown() {
    }

    public void testisFeatureSupported() throws Exception {
        for (int i = 0; i < MD_ALGOS.length; ++i) {
            String string = MD_ALGOS[i];
            DigestMethod digestMethod = this.factory.newDigestMethod(string, null);
            try {
                digestMethod.isFeatureSupported(null);
                DigestMethodTest.fail((String)"Should raise a NPE for null feature");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            DigestMethodTest.assertTrue((!digestMethod.isFeatureSupported("not supported") ? 1 : 0) != 0);
        }
    }

    public void testConstructor() throws Exception {
        DigestMethod digestMethod;
        for (int i = 0; i < MD_ALGOS.length; ++i) {
            String string = MD_ALGOS[i];
            digestMethod = this.factory.newDigestMethod(string, null);
            DigestMethodTest.assertEquals((String)digestMethod.getAlgorithm(), (String)string);
            DigestMethodTest.assertNull((Object)digestMethod.getParameterSpec());
            try {
                digestMethod = this.factory.newDigestMethod(string, new TestUtils.MyOwnDigestMethodParameterSpec());
                DigestMethodTest.fail((String)"Should raise an IAPE for invalid parameters");
                continue;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                continue;
            }
            catch (Exception exception) {
                DigestMethodTest.fail((String)("Should raise an IAPE instead of " + exception));
            }
        }
        try {
            digestMethod = this.factory.newDigestMethod("non-existent", null);
            DigestMethodTest.fail((String)"Should raise an NSAE for non-existent algos");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        try {
            digestMethod = this.factory.newDigestMethod(null, null);
            DigestMethodTest.fail((String)"Should raise a NPE for null algo");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

