/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Annotation;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RtfAnnotation
extends RtfElement {
    private static final byte[] ANNOTATION_ID = "\\*\\atnid".getBytes();
    private static final byte[] ANNOTATION_AUTHOR = "\\*\\atnauthor".getBytes();
    private static final byte[] ANNOTATION = "\\*\\annotation".getBytes();
    private String title = "";
    private String content = "";

    public RtfAnnotation(RtfDocument rtfDocument, Annotation annotation) {
        super(rtfDocument);
        this.title = annotation.title();
        this.content = annotation.content();
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeContent(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(OPEN_GROUP);
        outputStream.write(ANNOTATION_ID);
        outputStream.write(DELIMITER);
        outputStream.write(this.intToByteArray(this.document.getRandomInt()));
        outputStream.write(CLOSE_GROUP);
        outputStream.write(OPEN_GROUP);
        outputStream.write(ANNOTATION_AUTHOR);
        outputStream.write(DELIMITER);
        outputStream.write(this.title.getBytes());
        outputStream.write(CLOSE_GROUP);
        outputStream.write(OPEN_GROUP);
        outputStream.write(ANNOTATION);
        outputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        outputStream.write(DELIMITER);
        outputStream.write(this.content.getBytes());
        outputStream.write(CLOSE_GROUP);
    }
}

