/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.layout.LayoutEdge;
import ca.sqlpower.architect.layout.LayoutNode;
import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.olap.DimensionUsageEditPanel;
import ca.sqlpower.architect.swingui.olap.OLAPPane;
import ca.sqlpower.architect.swingui.olap.UsageComponentUI;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class UsageComponent
extends PlayPenComponent
implements LayoutEdge {
    public static final List<Class<? extends SPObject>> allowedChildTypes = PlayPenComponent.allowedChildTypes;
    private final OLAPObject model;
    private final OLAPPane<?, ?> pane1;
    private final OLAPPane<?, ?> pane2;
    private final OLAPPanesWatcher olapPanesWatcher = new OLAPPanesWatcher();

    public UsageComponent(UsageComponent copyMe, PlayPenContentPane parent) {
        super(copyMe, parent);
        this.model = copyMe.model;
        this.pane1 = copyMe.pane1;
        this.pane2 = copyMe.pane2;
        this.updateUI();
    }

    @Constructor
    public UsageComponent(@ConstructorParameter(propertyName="parent") PlayPenContentPane parent, @ConstructorParameter(propertyName="model") OLAPObject model, @ConstructorParameter(propertyName="pane1") OLAPPane<?, ?> pane1, @ConstructorParameter(propertyName="pane2") OLAPPane<?, ?> pane2) {
        super(model.getName(), parent);
        this.model = model;
        this.pane1 = pane1;
        this.pane2 = pane2;
        this.setOpaque(false);
        this.setForegroundColor(Color.BLACK);
        this.setBackgroundColor(Color.BLACK);
        this.updateUI();
        parent.addSPListener((SPListener)this.olapPanesWatcher);
    }

    protected void updateUI() {
        UsageComponentUI ui = new UsageComponentUI();
        ui.installUI(this);
        this.setUI(ui);
    }

    public OLAPObject getModel() {
        return this.model;
    }

    @Override
    public String getModelName() {
        return this.model.getName();
    }

    @Override
    public void handleMouseEvent(MouseEvent evt) {
        PlayPen pp = this.getPlayPen();
        if (evt.getID() == 501) {
            if (!this.isSelected()) {
                pp.selectNone();
                this.setSelected(true, 4);
            }
        } else if (evt.getID() == 503 || evt.getID() == 506) {
            this.setSelected(this.getUI().intersects(pp.getRubberBand()), 4);
        } else if (evt.getID() == 500 && evt.getClickCount() == 2 && evt.getButton() == 1 && this.model instanceof MondrianModel.DimensionUsage) {
            try {
                MondrianModel.DimensionUsage du = (MondrianModel.DimensionUsage)this.model;
                DimensionUsageEditPanel panel = new DimensionUsageEditPanel(du);
                if (panel != null) {
                    Window owner = SwingUtilities.getWindowAncestor(this.getPlayPen());
                    JDialog dialog = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)panel, (Component)owner, (String)"Modify Properties", (String)"OK");
                    dialog.setLocationRelativeTo(owner);
                    dialog.setVisible(true);
                }
            }
            catch (Exception e) {
                ASUtils.showExceptionDialogNoReport(SwingUtilities.getWindowAncestor(this.getPlayPen()), "Failed to create edit dialog!", e);
            }
        }
    }

    @Override
    @Transient
    @Accessor
    public UsageComponentUI getUI() {
        return (UsageComponentUI)super.getUI();
    }

    @Accessor
    public OLAPPane<?, ?> getPane1() {
        return this.pane1;
    }

    @Accessor
    public OLAPPane<?, ?> getPane2() {
        return this.pane2;
    }

    @Override
    @Transient
    @Accessor
    public LayoutNode getHeadNode() {
        return this.getPane2();
    }

    @Override
    @Transient
    @Accessor
    public LayoutNode getTailNode() {
        return this.getPane1();
    }

    public List<SPObject> getDependencies() {
        ArrayList<SPObject> dependsOn = new ArrayList<SPObject>();
        dependsOn.add((SPObject)this.pane1);
        dependsOn.add((SPObject)this.pane2);
        dependsOn.add((SPObject)this.model);
        return dependsOn;
    }

    @Override
    public void removeDependency(SPObject dependency) {
        if (this.getDependencies().contains(dependency)) {
            try {
                this.getParent().removeChild((SPObject)this);
            }
            catch (ObjectDependentException e) {
                throw new RuntimeException(e);
            }
            this.setParent(null);
        }
    }

    private class OLAPPanesWatcher
    extends AbstractSPListener {
        private OLAPPanesWatcher() {
        }

        public void childRemoved(SPChildEvent evt) {
            if (evt.getChild() == UsageComponent.this.pane1 || evt.getChild() == UsageComponent.this.pane2) {
                try {
                    UsageComponent.this.getParent().removeChild((SPObject)UsageComponent.this);
                }
                catch (ObjectDependentException e) {
                    throw new RuntimeException(e);
                }
            } else if (evt.getChild() == UsageComponent.this) {
                UsageComponent.this.getParent().removeSPListener((SPListener)this);
            }
        }
    }
}

