/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.blockingstep;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.blockingstep.BlockingStepData;
import org.pentaho.di.trans.steps.blockingstep.BlockingStepMeta;
import org.pentaho.di.trans.steps.blockingstep.Messages;

public class BlockingStep
extends BaseStep
implements StepInterface {
    private BlockingStepMeta meta;
    private BlockingStepData data;
    private Object[] lastRow;

    public BlockingStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private boolean addBuffer(RowMetaInterface rowMeta, Object[] r) {
        if (r != null) {
            this.data.buffer.add(r);
        }
        if (this.data.buffer.size() == this.meta.getCacheSize() || this.data.files.size() > 0 && r == null && this.data.buffer.size() > 0) {
            try {
                DataOutputStream dos;
                GZIPOutputStream gzos;
                FileObject fileObject = KettleVFS.createTempFile((String)this.meta.getPrefix(), (String)".tmp", (String)this.environmentSubstitute(this.meta.getDirectory()));
                this.data.files.add(fileObject);
                OutputStream outputStream = KettleVFS.getOutputStream((FileObject)fileObject, (boolean)false);
                if (this.meta.getCompress()) {
                    gzos = new GZIPOutputStream(new BufferedOutputStream(outputStream));
                    dos = new DataOutputStream(gzos);
                } else {
                    dos = new DataOutputStream(outputStream);
                    gzos = null;
                }
                dos.writeInt(this.data.buffer.size());
                for (int p = 0; p < this.data.buffer.size(); ++p) {
                    rowMeta.writeData(dos, this.data.buffer.get(p));
                }
                dos.close();
                if (gzos != null) {
                    gzos.close();
                }
                outputStream.close();
            }
            catch (Exception e) {
                this.logError("Error processing tmp-file: " + e.toString());
                return false;
            }
            this.data.buffer.clear();
        }
        return true;
    }

    private Object[] getBuffer() {
        Object[] retval;
        block21: {
            InputStream fi;
            if (this.data.files.size() > 0 && (this.data.dis.size() == 0 || this.data.fis.size() == 0)) {
                if (this.log.isBasic()) {
                    this.logBasic(Messages.getString("BlockingStep.Log.Openfiles"));
                }
                try {
                    DataInputStream di;
                    FileObject fileObject = this.data.files.get(0);
                    String filename = KettleVFS.getFilename((FileObject)fileObject);
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("BlockingStep.Log.Openfilename1") + filename + Messages.getString("BlockingStep.Log.Openfilename2"));
                    }
                    fi = KettleVFS.getInputStream((FileObject)fileObject);
                    this.data.fis.add(fi);
                    if (this.meta.getCompress()) {
                        GZIPInputStream gzfi = new GZIPInputStream(new BufferedInputStream(fi));
                        di = new DataInputStream(gzfi);
                        this.data.gzis.add(gzfi);
                    } else {
                        di = new DataInputStream(fi);
                    }
                    this.data.dis.add(di);
                    int buffersize = di.readInt();
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("BlockingStep.Log.BufferSize1") + filename + Messages.getString("BlockingStep.Log.BufferSize2") + buffersize + " " + Messages.getString("BlockingStep.Log.BufferSize3"));
                    }
                    if (buffersize > 0) {
                        this.data.rowbuffer.add(this.data.outputRowMeta.readData(di));
                    }
                }
                catch (Exception e) {
                    this.logError(Messages.getString("BlockingStepMeta.ErrorReadingFile") + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                }
            }
            if (this.data.files.size() == 0) {
                if (this.data.buffer.size() > 0) {
                    retval = this.data.buffer.get(0);
                    this.data.buffer.remove(0);
                } else {
                    retval = null;
                }
            } else if (this.data.rowbuffer.size() == 0) {
                retval = null;
            } else {
                retval = this.data.rowbuffer.get(0);
                this.data.rowbuffer.remove(0);
                FileObject file = this.data.files.get(0);
                DataInputStream di = this.data.dis.get(0);
                fi = this.data.fis.get(0);
                GZIPInputStream gzfi = this.meta.getCompress() ? this.data.gzis.get(0) : null;
                try {
                    this.data.rowbuffer.add(0, this.data.outputRowMeta.readData(di));
                }
                catch (SocketTimeoutException e) {
                    this.logError(Messages.getString("System.Log.UnexpectedError") + " : " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.setErrors(1L);
                    this.stopAll();
                }
                catch (KettleFileException fe) {
                    try {
                        di.close();
                        fi.close();
                        if (gzfi != null) {
                            gzfi.close();
                        }
                        file.delete();
                    }
                    catch (IOException e) {
                        this.logError(Messages.getString("BlockingStepMeta.UnableDeleteFile") + file.toString());
                        this.setErrors(1L);
                        this.stopAll();
                        return null;
                    }
                    this.data.files.remove(0);
                    this.data.dis.remove(0);
                    this.data.fis.remove(0);
                    if (gzfi == null) break block21;
                    this.data.gzis.remove(0);
                }
            }
        }
        return retval;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (BlockingStepMeta)smi;
        this.data = (BlockingStepData)sdi;
        return super.init(smi, sdi);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        boolean err = true;
        Object[] r = this.getRow();
        if (this.first && r != null) {
            this.data.outputRowMeta = this.getInputRowMeta().clone();
        }
        if (!this.meta.isPassAllRows()) {
            if (r == null) {
                if (this.lastRow != null) {
                    this.putRow(this.data.outputRowMeta, this.lastRow);
                }
                this.setOutputDone();
                return false;
            }
            this.lastRow = r;
            return true;
        }
        err = this.addBuffer(this.getInputRowMeta(), r);
        if (!err) {
            this.setOutputDone();
            return false;
        }
        if (r == null) {
            r = this.getBuffer();
            while (r != null && !this.isStopped()) {
                if (this.log.isRowLevel()) {
                    this.logRowlevel("Read row: " + this.getInputRowMeta().getString(r));
                }
                this.putRow(this.data.outputRowMeta, r);
                r = this.getBuffer();
            }
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

