/***************************************************************************
                           csingleton.h  -  description
                             -------------------
    begin                : Sun Jul 07 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSINGLETON_H
#define CSINGLETON_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>

template<typename type> class DLL_EXPORT CSingleton {
public:
	/** */
	CSingleton() {
	};
	/** */
	virtual ~CSingleton() {
		type::_instance_ptr = 0;
	};
	/** */
	static type * Instance() {
		return type::_instance_ptr;
	};
	/** */
	static void SetInstance( type * t ) {
		type::_instance_ptr = t;
	};

protected:
	/** */
	static type * _instance_ptr;
};

template <typename type> type* CSingleton <type>::_instance_ptr = 0;

#endif
