/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatCountIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatDistinctCountIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatSumIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatVarianceIncrementer;

public class JRFloatIncrementerFactory
extends JRAbstractExtendedIncrementerFactory {
    protected static final Float ZERO = new Float(0.0f);
    private static JRFloatIncrementerFactory mainInstance = new JRFloatIncrementerFactory();

    public static JRFloatIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRExtendedIncrementer getExtendedIncrementer(byte calculation) {
        JRExtendedIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRFloatCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRFloatSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRFloatAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRFloatStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRFloatVarianceIncrementer.getInstance();
                break;
            }
            case 10: {
                incrementer = JRFloatDistinctCountIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

