/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.common.util.Pair;

public class MoveReplicaSuggester
extends Suggester {
    @Override
    SolrRequest init() {
        SolrRequest operation = this.tryEachNode(true);
        if (operation == null) {
            operation = this.tryEachNode(false);
        }
        return operation;
    }

    SolrRequest tryEachNode(boolean strict) {
        List<Violation> leastSeriousViolation = null;
        Integer targetNodeIndex = null;
        Integer sourceNodeIndex = null;
        ReplicaInfo sourceReplicaInfo = null;
        for (Pair<ReplicaInfo, Row> fromReplica : this.getValidReplicas(true, true, -1)) {
            String shard;
            ReplicaInfo replicaInfo;
            String coll;
            Row fromRow = fromReplica.second();
            Pair<Row, ReplicaInfo> pair = fromRow.removeReplica(coll = (replicaInfo = fromReplica.first()).getCollection(), shard = replicaInfo.getShard(), replicaInfo.getType());
            Row srcTmpRow = pair.first();
            if (srcTmpRow == null) continue;
            int i = this.getMatrix().indexOf(fromRow);
            int stopAt = this.force ? 0 : i;
            for (int j = this.getMatrix().size() - 1; j >= stopAt; --j) {
                if (j == i) continue;
                Row targetRow = this.getMatrix().get(j);
                if (!targetRow.isLive || !this.isAllowed(targetRow.node, Suggester.Hint.TARGET_NODE)) continue;
                targetRow = targetRow.addReplica(coll, shard, replicaInfo.getType());
                List<Violation> errs = this.testChangedMatrix(strict, this.getModifiedMatrix(this.getModifiedMatrix(this.getMatrix(), srcTmpRow, i), targetRow, j));
                if (this.containsNewErrors(errs) || !this.isLessSerious(errs, leastSeriousViolation) || !this.force && Policy.compareRows(srcTmpRow, targetRow, this.session.getPolicy()) >= 1) continue;
                leastSeriousViolation = errs;
                targetNodeIndex = j;
                sourceNodeIndex = i;
                sourceReplicaInfo = replicaInfo;
            }
        }
        if (targetNodeIndex != null && sourceNodeIndex != null) {
            this.getMatrix().set(sourceNodeIndex, this.getMatrix().get(sourceNodeIndex).removeReplica(sourceReplicaInfo.getCollection(), sourceReplicaInfo.getShard(), sourceReplicaInfo.getType()).first());
            this.getMatrix().set(targetNodeIndex, this.getMatrix().get(targetNodeIndex).addReplica(sourceReplicaInfo.getCollection(), sourceReplicaInfo.getShard(), sourceReplicaInfo.getType()));
            return new CollectionAdminRequest.MoveReplica(sourceReplicaInfo.getCollection(), sourceReplicaInfo.getName(), this.getMatrix().get((int)targetNodeIndex.intValue()).node);
        }
        return null;
    }
}

