/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.stats;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandles;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.AggregateMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String METRIC_NAME = "metric";
    public static final String VALUE = "value";
    public static final String VALUES = "values";
    static final String MS = "_ms";
    static final String MIN = "min";
    static final String MIN_MS = "min_ms";
    static final String MAX = "max";
    static final String MAX_MS = "max_ms";
    static final String MEAN = "mean";
    static final String MEAN_MS = "mean_ms";
    static final String MEDIAN = "median";
    static final String MEDIAN_MS = "median_ms";
    static final String STDDEV = "stddev";
    static final String STDDEV_MS = "stddev_ms";
    static final String SUM = "sum";
    static final String P75 = "p75";
    static final String P75_MS = "p75_ms";
    static final String P95 = "p95";
    static final String P95_MS = "p95_ms";
    static final String P99 = "p99";
    static final String P99_MS = "p99_ms";
    static final String P999 = "p999";
    static final String P999_MS = "p999_ms";
    public static String[] OS_MXBEAN_CLASSES = new String[]{OperatingSystemMXBean.class.getName(), "com.sun.management.OperatingSystemMXBean", "com.sun.management.UnixOperatingSystemMXBean", "com.ibm.lang.management.OperatingSystemMXBean"};

    public static void addMetrics(NamedList<Object> lst, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        lst.add("avgRequestsPerSecond", (Object)timer.getMeanRate());
        lst.add("5minRateRequestsPerSecond", (Object)timer.getFiveMinuteRate());
        lst.add("15minRateRequestsPerSecond", (Object)timer.getFifteenMinuteRate());
        lst.add("avgTimePerRequest", (Object)MetricUtils.nsToMs(snapshot.getMean()));
        lst.add("medianRequestTime", (Object)MetricUtils.nsToMs(snapshot.getMedian()));
        lst.add("75thPcRequestTime", (Object)MetricUtils.nsToMs(snapshot.get75thPercentile()));
        lst.add("95thPcRequestTime", (Object)MetricUtils.nsToMs(snapshot.get95thPercentile()));
        lst.add("99thPcRequestTime", (Object)MetricUtils.nsToMs(snapshot.get99thPercentile()));
        lst.add("999thPcRequestTime", (Object)MetricUtils.nsToMs(snapshot.get999thPercentile()));
    }

    public static double nsToMs(double ns) {
        return ns / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    }

    public static void toSolrInputDocuments(MetricRegistry registry, List<MetricFilter> shouldMatchFilters, MetricFilter mustMatchFilter, PropertyFilter propertyFilter, boolean skipHistograms, boolean skipAggregateValues, boolean compact, Map<String, Object> metadata, Consumer<SolrInputDocument> consumer) {
        boolean addMetadata = metadata != null && !metadata.isEmpty();
        MetricUtils.toMaps(registry, shouldMatchFilters, mustMatchFilter, propertyFilter, skipHistograms, skipAggregateValues, compact, false, (k, v) -> {
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            doc.setField(METRIC_NAME, k);
            MetricUtils.toSolrInputDocument(null, doc, v);
            if (addMetadata) {
                MetricUtils.toSolrInputDocument(null, doc, metadata);
            }
            consumer.accept(doc);
        });
    }

    static void toSolrInputDocument(String prefix, SolrInputDocument doc, Object o) {
        if (!(o instanceof Map)) {
            String key = prefix != null ? prefix : VALUE;
            doc.addField(key, o);
            return;
        }
        Map map = (Map)o;
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                MetricUtils.toSolrInputDocument((String)entry.getKey(), doc, entry.getValue());
                continue;
            }
            String key = prefix != null ? prefix + "." + (String)entry.getKey() : (String)entry.getKey();
            doc.addField(key, entry.getValue());
        }
    }

    public static void toMaps(MetricRegistry registry, List<MetricFilter> shouldMatchFilters, MetricFilter mustMatchFilter, PropertyFilter propertyFilter, boolean skipHistograms, boolean skipAggregateValues, boolean compact, boolean simple, BiConsumer<String, Object> consumer) {
        Map metrics = registry.getMetrics();
        SortedSet names = registry.getNames();
        names.stream().filter(s -> shouldMatchFilters.stream().anyMatch(metricFilter -> metricFilter.matches(s, (Metric)metrics.get(s)))).filter(s -> mustMatchFilter.matches(s, (Metric)metrics.get(s))).forEach(n -> {
            Metric metric = (Metric)metrics.get(n);
            MetricUtils.convertMetric(n, metric, propertyFilter, skipHistograms, skipAggregateValues, compact, simple, ".", consumer);
        });
    }

    public static Map<String, Object> convertMetrics(MetricRegistry registry, Collection<String> names) {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        MetricUtils.convertMetrics(registry, names, false, true, true, true, (k, v) -> metrics.put((String)k, v));
        return metrics;
    }

    public static void convertMetrics(MetricRegistry registry, Collection<String> names, boolean skipHistograms, boolean skipAggregateValues, boolean compact, boolean simple, BiConsumer<String, Object> consumer) {
        Map metrics = registry.getMetrics();
        names.stream().forEach(n -> {
            Metric metric = (Metric)metrics.get(n);
            MetricUtils.convertMetric(n, metric, PropertyFilter.ALL, skipHistograms, skipAggregateValues, compact, simple, ".", consumer);
        });
    }

    public static void convertMetric(String n, Metric metric, PropertyFilter propertyFilter, boolean skipHistograms, boolean skipAggregateValues, boolean compact, boolean simple, String separator, BiConsumer<String, Object> consumer) {
        if (metric instanceof Counter) {
            Counter counter = (Counter)metric;
            MetricUtils.convertCounter(n, counter, propertyFilter, compact, consumer);
        } else if (metric instanceof Gauge) {
            Gauge gauge = (Gauge)metric;
            try {
                MetricUtils.convertGauge(n, gauge, propertyFilter, simple, compact, separator, consumer);
            }
            catch (InternalError ie) {
                if (n.startsWith("memory.") && ie.getMessage().contains("Memory Pool not found")) {
                    LOG.warn("Error converting gauge '" + n + "', possible JDK bug: SOLR-10362", (Throwable)ie);
                    consumer.accept(n, null);
                }
                throw ie;
            }
        } else if (metric instanceof Meter) {
            Meter meter = (Meter)metric;
            MetricUtils.convertMeter(n, meter, propertyFilter, simple, separator, consumer);
        } else if (metric instanceof Timer) {
            Timer timer = (Timer)metric;
            MetricUtils.convertTimer(n, timer, propertyFilter, skipHistograms, simple, separator, consumer);
        } else if (metric instanceof Histogram) {
            if (!skipHistograms) {
                Histogram histogram = (Histogram)metric;
                MetricUtils.convertHistogram(n, histogram, propertyFilter, simple, separator, consumer);
            }
        } else if (metric instanceof AggregateMetric) {
            MetricUtils.convertAggregateMetric(n, (AggregateMetric)metric, propertyFilter, skipAggregateValues, simple, separator, consumer);
        }
    }

    static void convertAggregateMetric(String name, AggregateMetric metric, PropertyFilter propertyFilter, boolean skipAggregateValues, boolean simple, String separator, BiConsumer<String, Object> consumer) {
        if (simple) {
            if (propertyFilter.accept(MEAN)) {
                consumer.accept(name + separator + MEAN, metric.getMean());
            }
        } else {
            LinkedHashMap response = new LinkedHashMap();
            BiConsumer<String, Object> filter = (k, v) -> {
                if (propertyFilter.accept((String)k)) {
                    response.put((String)k, v);
                }
            };
            filter.accept("count", metric.size());
            filter.accept(MAX, metric.getMax());
            filter.accept(MIN, metric.getMin());
            filter.accept(MEAN, metric.getMean());
            filter.accept(STDDEV, metric.getStdDev());
            filter.accept(SUM, metric.getSum());
            if (!metric.isEmpty() && !skipAggregateValues) {
                LinkedHashMap values = new LinkedHashMap();
                response.put(VALUES, values);
                metric.getValues().forEach((k, v) -> {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    map.put(VALUE, v.value);
                    map.put("updateCount", v.updateCount.get());
                    values.put(k, map);
                });
            }
            if (!response.isEmpty()) {
                consumer.accept(name, response);
            }
        }
    }

    static void convertHistogram(String name, Histogram histogram, PropertyFilter propertyFilter, boolean simple, String separator, BiConsumer<String, Object> consumer) {
        Snapshot snapshot = histogram.getSnapshot();
        if (simple) {
            if (propertyFilter.accept(MEAN)) {
                consumer.accept(name + separator + MEAN, snapshot.getMean());
            }
        } else {
            LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
            String prop = "count";
            if (propertyFilter.accept(prop)) {
                response.put(prop, histogram.getCount());
            }
            MetricUtils.addSnapshot(response, snapshot, propertyFilter, false);
            if (!response.isEmpty()) {
                consumer.accept(name, response);
            }
        }
    }

    static double nsToMs(boolean convert, double value) {
        if (convert) {
            return MetricUtils.nsToMs(value);
        }
        return value;
    }

    static void addSnapshot(Map<String, Object> response, Snapshot snapshot, PropertyFilter propertyFilter, boolean ms) {
        BiConsumer<String, Object> filter = (k, v) -> {
            if (propertyFilter.accept((String)k)) {
                response.put((String)k, v);
            }
        };
        filter.accept(ms ? MIN_MS : MIN, MetricUtils.nsToMs(ms, snapshot.getMin()));
        filter.accept(ms ? MAX_MS : MAX, MetricUtils.nsToMs(ms, snapshot.getMax()));
        filter.accept(ms ? MEAN_MS : MEAN, MetricUtils.nsToMs(ms, snapshot.getMean()));
        filter.accept(ms ? MEDIAN_MS : MEDIAN, MetricUtils.nsToMs(ms, snapshot.getMedian()));
        filter.accept(ms ? STDDEV_MS : STDDEV, MetricUtils.nsToMs(ms, snapshot.getStdDev()));
        filter.accept(ms ? P75_MS : P75, MetricUtils.nsToMs(ms, snapshot.get75thPercentile()));
        filter.accept(ms ? P95_MS : P95, MetricUtils.nsToMs(ms, snapshot.get95thPercentile()));
        filter.accept(ms ? P99_MS : P99, MetricUtils.nsToMs(ms, snapshot.get99thPercentile()));
        filter.accept(ms ? P999_MS : P999, MetricUtils.nsToMs(ms, snapshot.get999thPercentile()));
    }

    public static void convertTimer(String name, Timer timer, PropertyFilter propertyFilter, boolean skipHistograms, boolean simple, String separator, BiConsumer<String, Object> consumer) {
        if (simple) {
            String prop = "meanRate";
            if (propertyFilter.accept(prop)) {
                consumer.accept(name + separator + prop, timer.getMeanRate());
            }
        } else {
            LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
            BiConsumer<String, Object> filter = (k, v) -> {
                if (propertyFilter.accept((String)k)) {
                    response.put((String)k, v);
                }
            };
            filter.accept("count", timer.getCount());
            filter.accept("meanRate", timer.getMeanRate());
            filter.accept("1minRate", timer.getOneMinuteRate());
            filter.accept("5minRate", timer.getFiveMinuteRate());
            filter.accept("15minRate", timer.getFifteenMinuteRate());
            if (!skipHistograms) {
                MetricUtils.addSnapshot(response, timer.getSnapshot(), propertyFilter, true);
            }
            if (!response.isEmpty()) {
                consumer.accept(name, response);
            }
        }
    }

    static void convertMeter(String name, Meter meter, PropertyFilter propertyFilter, boolean simple, String separator, BiConsumer<String, Object> consumer) {
        if (simple) {
            if (propertyFilter.accept("count")) {
                consumer.accept(name + separator + "count", meter.getCount());
            }
        } else {
            LinkedHashMap response = new LinkedHashMap();
            BiConsumer<String, Object> filter = (k, v) -> {
                if (propertyFilter.accept((String)k)) {
                    response.put(k, v);
                }
            };
            filter.accept("count", meter.getCount());
            filter.accept("meanRate", meter.getMeanRate());
            filter.accept("1minRate", meter.getOneMinuteRate());
            filter.accept("5minRate", meter.getFiveMinuteRate());
            filter.accept("15minRate", meter.getFifteenMinuteRate());
            if (!response.isEmpty()) {
                consumer.accept(name, response);
            }
        }
    }

    static void convertGauge(String name, Gauge gauge, PropertyFilter propertyFilter, boolean simple, boolean compact, String separator, BiConsumer<String, Object> consumer) {
        if (compact || simple) {
            Object o = gauge.getValue();
            if (o instanceof Map) {
                if (simple) {
                    for (Map.Entry entry : ((Map)o).entrySet()) {
                        String prop = entry.getKey().toString();
                        if (!propertyFilter.accept(prop)) continue;
                        consumer.accept(name + separator + prop, entry.getValue());
                    }
                } else {
                    HashMap val = new HashMap();
                    for (Map.Entry entry : ((Map)o).entrySet()) {
                        String prop = entry.getKey().toString();
                        if (!propertyFilter.accept(prop)) continue;
                        val.put(prop, entry.getValue());
                    }
                    if (!val.isEmpty()) {
                        consumer.accept(name, val);
                    }
                }
            } else {
                consumer.accept(name, o);
            }
        } else {
            Object o = gauge.getValue();
            LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
            if (o instanceof Map) {
                for (Map.Entry entry : ((Map)o).entrySet()) {
                    String prop = entry.getKey().toString();
                    if (!propertyFilter.accept(prop)) continue;
                    response.put(prop, entry.getValue());
                }
                if (!response.isEmpty()) {
                    consumer.accept(name, Collections.singletonMap(VALUE, response));
                }
            } else if (propertyFilter.accept(VALUE)) {
                response.put(VALUE, o);
                consumer.accept(name, response);
            }
        }
    }

    static void convertCounter(String name, Counter counter, PropertyFilter propertyFilter, boolean compact, BiConsumer<String, Object> consumer) {
        if (compact) {
            consumer.accept(name, counter.getCount());
        } else if (propertyFilter.accept("count")) {
            LinkedHashMap<String, Long> response = new LinkedHashMap<String, Long>();
            response.put("count", counter.getCount());
            consumer.accept(name, response);
        }
    }

    public static ExecutorService instrumentedExecutorService(ExecutorService delegate, SolrInfoBean info, MetricRegistry metricRegistry, String scope) {
        if (info != null && info.getMetricNames() != null) {
            info.getMetricNames().add(MetricRegistry.name((String)scope, (String[])new String[]{"submitted"}));
            info.getMetricNames().add(MetricRegistry.name((String)scope, (String[])new String[]{"running"}));
            info.getMetricNames().add(MetricRegistry.name((String)scope, (String[])new String[]{"completed"}));
            info.getMetricNames().add(MetricRegistry.name((String)scope, (String[])new String[]{"duration"}));
        }
        return new InstrumentedExecutorService(delegate, metricRegistry, scope);
    }

    public static <T extends PlatformManagedObject> void addMXBeanMetrics(T obj, Class<? extends T> intf, String prefix, BiConsumer<String, Metric> consumer) {
        if (intf.isInstance(obj)) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(intf, intf.getSuperclass(), 3);
            }
            catch (IntrospectionException e) {
                LOG.warn("Unable to fetch properties of MXBean " + obj.getClass().getName());
                return;
            }
            for (PropertyDescriptor desc : beanInfo.getPropertyDescriptors()) {
                String name = desc.getName();
                try {
                    desc.getReadMethod().invoke(obj, new Object[0]);
                    Gauge gauge = () -> {
                        try {
                            return desc.getReadMethod().invoke((Object)obj, new Object[0]);
                        }
                        catch (InvocationTargetException ite) {
                            return null;
                        }
                        catch (IllegalAccessException e) {
                            return null;
                        }
                    };
                    String metricName = MetricRegistry.name((String)prefix, (String[])new String[]{name});
                    consumer.accept(metricName, (Metric)gauge);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static <T extends PlatformManagedObject> void addMXBeanMetrics(T obj, String[] interfaces, String prefix, BiConsumer<String, Metric> consumer) {
        for (String clazz : interfaces) {
            try {
                Class<PlatformManagedObject> intf = Class.forName(clazz).asSubclass(PlatformManagedObject.class);
                MetricUtils.addMXBeanMetrics(obj, intf, null, consumer);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static interface PropertyFilter {
        public static final PropertyFilter ALL = name -> true;

        public boolean accept(String var1);
    }
}

