/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.stats;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.util.stats.HttpClientMetricNameStrategy;

public class InstrumentedHttpRequestExecutor
extends HttpRequestExecutor
implements SolrMetricProducer {
    public static final HttpClientMetricNameStrategy QUERYLESS_URL_AND_METHOD = (scope, request) -> {
        try {
            HttpRequestWrapper wrapper;
            RequestLine requestLine = request.getRequestLine();
            String schemeHostPort = null;
            if (request instanceof HttpRequestWrapper && (wrapper = (HttpRequestWrapper)request).getTarget() != null) {
                schemeHostPort = wrapper.getTarget().getSchemeName() + "://" + wrapper.getTarget().getHostName() + ":" + wrapper.getTarget().getPort();
            }
            URIBuilder url = new URIBuilder(requestLine.getUri());
            return SolrMetricManager.mkName((schemeHostPort != null ? schemeHostPort : "") + url.removeQuery().build().toString() + "." + InstrumentedHttpRequestExecutor.methodNameString(request), scope);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    };
    public static final HttpClientMetricNameStrategy METHOD_ONLY = (scope, request) -> SolrMetricManager.mkName(InstrumentedHttpRequestExecutor.methodNameString(request), scope);
    public static final HttpClientMetricNameStrategy HOST_AND_METHOD = (scope, request) -> {
        try {
            HttpRequestWrapper wrapper;
            RequestLine requestLine = request.getRequestLine();
            String schemeHostPort = null;
            if (request instanceof HttpRequestWrapper && (wrapper = (HttpRequestWrapper)request).getTarget() != null) {
                schemeHostPort = wrapper.getTarget().getSchemeName() + "://" + wrapper.getTarget().getHostName() + ":" + wrapper.getTarget().getPort();
            }
            URIBuilder url = new URIBuilder(requestLine.getUri());
            return SolrMetricManager.mkName((schemeHostPort != null ? schemeHostPort : "") + "." + InstrumentedHttpRequestExecutor.methodNameString(request), scope);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    };
    public static final Map<String, HttpClientMetricNameStrategy> KNOWN_METRIC_NAME_STRATEGIES = new HashMap<String, HttpClientMetricNameStrategy>(3);
    protected MetricRegistry metricsRegistry;
    protected String scope;
    protected HttpClientMetricNameStrategy nameStrategy;

    public InstrumentedHttpRequestExecutor(int waitForContinue, HttpClientMetricNameStrategy nameStrategy) {
        super(waitForContinue);
        this.nameStrategy = nameStrategy;
    }

    public InstrumentedHttpRequestExecutor(HttpClientMetricNameStrategy nameStrategy) {
        this.nameStrategy = nameStrategy;
    }

    private static String methodNameString(HttpRequest request) {
        return request.getRequestLine().getMethod().toLowerCase(Locale.ROOT) + ".requests";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        Timer.Context timerContext = null;
        if (this.metricsRegistry != null) {
            timerContext = this.timer(request).time();
        }
        try {
            HttpResponse httpResponse = super.execute(request, conn, context);
            return httpResponse;
        }
        finally {
            if (timerContext != null) {
                timerContext.stop();
            }
        }
    }

    private Timer timer(HttpRequest request) {
        return this.metricsRegistry.timer(this.nameStrategy.getNameFor(this.scope, request));
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registry, String scope) {
        this.metricsRegistry = manager.registry(registry);
        this.scope = scope;
    }

    static {
        KNOWN_METRIC_NAME_STRATEGIES.put("queryLessURLAndMethod", QUERYLESS_URL_AND_METHOD);
        KNOWN_METRIC_NAME_STRATEGIES.put("hostAndMethod", HOST_AND_METHOD);
        KNOWN_METRIC_NAME_STRATEGIES.put("methodOnly", METHOD_ONLY);
    }
}

