/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.uninverting.UninvertingReader;

public class SolrFieldCacheBean
implements SolrInfoBean,
SolrMetricProducer {
    private boolean disableEntryList = Boolean.getBoolean("disableSolrFieldCacheMBeanEntryList");
    private boolean disableJmxEntryList = Boolean.getBoolean("disableSolrFieldCacheMBeanEntryListJmx");
    private MetricRegistry registry;
    private Set<String> metricNames = ConcurrentHashMap.newKeySet();

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public String getDescription() {
        return "Provides introspection of the Solr FieldCache ";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.CACHE;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.registry;
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registryName, String scope) {
        this.registry = manager.registry(registryName);
        MetricsMap metricsMap = new MetricsMap((detailed, map) -> {
            if (detailed.booleanValue() && !this.disableEntryList && !this.disableJmxEntryList) {
                UninvertingReader.FieldCacheStats fieldCacheStats = UninvertingReader.getUninvertedStats();
                String[] entries = fieldCacheStats.info;
                map.put("entries_count", entries.length);
                map.put("total_size", fieldCacheStats.totalSize);
                for (int i = 0; i < entries.length; ++i) {
                    String entry = entries[i];
                    map.put("entry#" + i, entry);
                }
            } else {
                map.put("entries_count", UninvertingReader.getUninvertedStatsSize());
            }
        });
        manager.register(this, registryName, (Metric)metricsMap, true, "fieldCache", SolrInfoBean.Category.CACHE.toString(), scope);
    }
}

