/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;

public abstract class BaseMergePolicyTestCase
extends LuceneTestCase {
    protected abstract MergePolicy mergePolicy();

    public void testForceMergeNotNeeded() throws IOException {
        try (BaseDirectoryWrapper dir = BaseMergePolicyTestCase.newDirectory();){
            int i;
            final AtomicBoolean mayMerge = new AtomicBoolean(true);
            SerialMergeScheduler mergeScheduler = new SerialMergeScheduler(){

                public synchronized void merge(IndexWriter writer, MergeTrigger trigger, boolean newMergesFound) throws IOException {
                    MergePolicy.OneMerge merge;
                    if (!mayMerge.get() && (merge = writer.getNextMerge()) != null) {
                        System.out.println("TEST: we should not need any merging, yet merge policy returned merge " + merge);
                        throw new AssertionError();
                    }
                    super.merge(writer, trigger, newMergesFound);
                }
            };
            MergePolicy mp = this.mergePolicy();
            BaseMergePolicyTestCase.assumeFalse("this test cannot tolerate random forceMerges", mp.toString().contains("MockRandomMergePolicy"));
            mp.setNoCFSRatio(BaseMergePolicyTestCase.random().nextBoolean() ? 0.0 : 1.0);
            IndexWriterConfig iwc = BaseMergePolicyTestCase.newIndexWriterConfig(new MockAnalyzer(BaseMergePolicyTestCase.random()));
            iwc.setMergeScheduler((MergeScheduler)mergeScheduler);
            iwc.setMergePolicy(mp);
            IndexWriter writer = new IndexWriter((Directory)dir, iwc);
            int numSegments = TestUtil.nextInt(BaseMergePolicyTestCase.random(), 2, 20);
            for (i = 0; i < numSegments; ++i) {
                int numDocs = TestUtil.nextInt(BaseMergePolicyTestCase.random(), 1, 5);
                for (int j = 0; j < numDocs; ++j) {
                    writer.addDocument((Iterable)new Document());
                }
                writer.getReader().close();
            }
            for (i = 5; i >= 0; --i) {
                int segmentCount = writer.getSegmentCount();
                int maxNumSegments = i == 0 ? 1 : TestUtil.nextInt(BaseMergePolicyTestCase.random(), 1, 10);
                mayMerge.set(segmentCount > maxNumSegments);
                if (VERBOSE) {
                    System.out.println("TEST: now forceMerge(maxNumSegments=" + maxNumSegments + ") vs segmentCount=" + segmentCount);
                }
                writer.forceMerge(maxNumSegments);
            }
            writer.close();
        }
    }
}

