/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.listeners.antxml;

import com.carrotsearch.ant.tasks.junit4.JUnit4;
import com.carrotsearch.ant.tasks.junit4.TestsSummaryEventListener;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Strings;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Throwables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Subscribe;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.CharStreams;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Files;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Persister;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.RegistryMatcher;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedQuitEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedSuiteResultEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedTestResultEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.TestStatus;
import com.carrotsearch.ant.tasks.junit4.events.mirrors.FailureMirror;
import com.carrotsearch.ant.tasks.junit4.listeners.AggregatedEventListener;
import com.carrotsearch.ant.tasks.junit4.listeners.antxml.FailureModel;
import com.carrotsearch.ant.tasks.junit4.listeners.antxml.MavenFailsafeSummaryModel;
import com.carrotsearch.ant.tasks.junit4.listeners.antxml.PropertyModel;
import com.carrotsearch.ant.tasks.junit4.listeners.antxml.TestCaseModel;
import com.carrotsearch.ant.tasks.junit4.listeners.antxml.TestSuiteModel;
import com.carrotsearch.ant.tasks.junit4.listeners.antxml.XmlStringTransformer;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.filters.TokenFilter;
import org.junit.runner.Description;

public class AntXmlReport
implements AggregatedEventListener {
    private JUnit4 junit4;
    private File dir;
    private boolean mavenExtensions = true;
    private File summaryFile;
    private List filters = new ArrayList();
    private Map suiteCounts = new HashMap();
    private boolean ignoreDuplicateSuites;
    private boolean outputStreams = true;
    private final TestsSummaryEventListener summaryListener = new TestsSummaryEventListener();

    public void setDir(File file) {
        this.dir = file;
    }

    public void setSummaryFile(File file) {
        this.summaryFile = file;
    }

    public void setOutputStreams(boolean bl) {
        this.outputStreams = bl;
    }

    public void setMavenExtensions(boolean bl) {
        this.mavenExtensions = bl;
    }

    public void setIgnoreDuplicateSuites(boolean bl) {
        this.ignoreDuplicateSuites = bl;
    }

    public void addConfiguredTokenFilter(TokenFilter tokenFilter) {
        this.filters.add(tokenFilter);
    }

    @Override
    public void setOuter(JUnit4 jUnit4) {
        this.junit4 = jUnit4;
        if (this.dir == null) {
            throw new BuildException("'dir' attribute is required (target folder for reports).");
        }
        try {
            Files.createParentDirs(this.dir);
            if (!this.dir.exists() && !this.dir.mkdir()) {
                throw new IOException("Could not mkdir: " + this.dir);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Could not create parent folders of: " + this.dir, (Throwable)iOException);
        }
        try {
            if (this.summaryFile != null) {
                Files.createParentDirs(this.summaryFile);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Could not create parent folders of: " + this.summaryFile, (Throwable)iOException);
        }
    }

    @Subscribe
    public void onQuit(AggregatedQuitEvent aggregatedQuitEvent) {
        if (this.summaryFile != null) {
            try {
                Persister persister = new Persister();
                persister.write((Object)new MavenFailsafeSummaryModel(this.summaryListener.getResult()), this.summaryFile);
            }
            catch (Exception exception) {
                this.junit4.log("Could not serialize summary report.", exception, 1);
            }
        }
    }

    @Subscribe
    public void onSuiteResult(AggregatedSuiteResultEvent aggregatedSuiteResultEvent) {
        this.summaryListener.suiteSummary(aggregatedSuiteResultEvent);
        Description description = aggregatedSuiteResultEvent.getDescription();
        String string = description.getDisplayName();
        if (string.trim().isEmpty()) {
            this.junit4.log("Could not emit XML report for suite (null description).", 1);
            return;
        }
        if (!this.suiteCounts.containsKey(string)) {
            this.suiteCounts.put(string, 1);
        } else {
            int n = (Integer)this.suiteCounts.get(string) + 1;
            this.suiteCounts.put(string, n);
            if (!this.ignoreDuplicateSuites && n == 2) {
                this.junit4.log("Duplicate suite name used with XML reports: " + string + ". This may confuse tools that process XML reports. " + "Set 'ignoreDuplicateSuites' to true to skip this message.", 1);
            }
            string = string + "-" + n;
        }
        try {
            File file = new File(this.dir, "TEST-" + string + ".xml");
            RegistryMatcher registryMatcher = new RegistryMatcher();
            registryMatcher.bind(String.class, new XmlStringTransformer());
            Persister persister = new Persister(registryMatcher);
            persister.write((Object)this.buildModel(aggregatedSuiteResultEvent), file);
        }
        catch (Exception exception) {
            this.junit4.log("Could not serialize report for suite " + string + ": " + exception.toString(), exception, 1);
        }
    }

    private TestSuiteModel buildModel(AggregatedSuiteResultEvent aggregatedSuiteResultEvent) {
        Object object;
        Object object22;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ROOT);
        TestSuiteModel testSuiteModel = new TestSuiteModel();
        testSuiteModel.hostname = "nohost.nodomain";
        testSuiteModel.name = aggregatedSuiteResultEvent.getDescription().getDisplayName();
        testSuiteModel.properties = this.buildModel(aggregatedSuiteResultEvent.getSlave().getSystemProperties());
        testSuiteModel.time = (double)aggregatedSuiteResultEvent.getExecutionTime() / 1000.0;
        testSuiteModel.timestamp = simpleDateFormat.format(new Date(aggregatedSuiteResultEvent.getStartTimestamp()));
        testSuiteModel.testcases = this.buildModel(aggregatedSuiteResultEvent.getTests());
        testSuiteModel.tests = testSuiteModel.testcases.size();
        if (this.mavenExtensions) {
            testSuiteModel.skipped = 0;
        }
        for (Object object22 : aggregatedSuiteResultEvent.getFailures()) {
            object = new TestCaseModel();
            ((TestCaseModel)object).classname = "junit.framework.TestSuite";
            ((TestCaseModel)object).name = this.applyFilters(((FailureMirror)object22).getDescription().getClassName());
            ((TestCaseModel)object).time = 0.0;
            if (((FailureMirror)object22).isAssertionViolation()) {
                ((TestCaseModel)object).failures.add(this.buildModel((FailureMirror)object22));
            } else {
                ((TestCaseModel)object).errors.add(this.buildModel((FailureMirror)object22));
            }
            testSuiteModel.testcases.add(object);
        }
        for (Object object22 : testSuiteModel.testcases) {
            testSuiteModel.errors += ((TestCaseModel)object22).errors.size();
            testSuiteModel.failures += ((TestCaseModel)object22).failures.size();
            if (!this.mavenExtensions || ((TestCaseModel)object22).skipped == null) continue;
            object = testSuiteModel;
            Integer.valueOf(((TestSuiteModel)object).skipped + 1);
            ((TestSuiteModel)object).skipped = ((TestSuiteModel)object).skipped;
        }
        StringWriter stringWriter = new StringWriter();
        object22 = new StringWriter();
        if (this.outputStreams) {
            aggregatedSuiteResultEvent.getSlave().decodeStreams(aggregatedSuiteResultEvent.getEventStream(), stringWriter, (Writer)object22);
        }
        testSuiteModel.sysout = stringWriter.toString();
        testSuiteModel.syserr = ((StringWriter)object22).toString();
        return testSuiteModel;
    }

    private List buildModel(List list) {
        ArrayList<TestCaseModel> arrayList = new ArrayList<TestCaseModel>();
        for (AggregatedTestResultEvent aggregatedTestResultEvent : list) {
            TestCaseModel testCaseModel = new TestCaseModel();
            if (aggregatedTestResultEvent.getStatus() == TestStatus.IGNORED || aggregatedTestResultEvent.getStatus() == TestStatus.IGNORED_ASSUMPTION) {
                if (!this.mavenExtensions) continue;
                testCaseModel.skipped = "";
            }
            testCaseModel.name = this.applyFilters(aggregatedTestResultEvent.getDescription().getMethodName());
            testCaseModel.classname = aggregatedTestResultEvent.getDescription().getClassName();
            testCaseModel.time = (double)aggregatedTestResultEvent.getExecutionTime() / 1000.0;
            for (FailureMirror failureMirror : aggregatedTestResultEvent.getFailures()) {
                if (failureMirror.isAssumptionViolation()) continue;
                if (failureMirror.isAssertionViolation()) {
                    testCaseModel.failures.add(this.buildModel(failureMirror));
                    continue;
                }
                testCaseModel.errors.add(this.buildModel(failureMirror));
            }
            arrayList.add(testCaseModel);
        }
        return arrayList;
    }

    private String applyFilters(String string) {
        if (this.filters.isEmpty()) {
            return string;
        }
        Reader reader = new StringReader(string);
        for (TokenFilter tokenFilter : this.filters) {
            reader = tokenFilter.chain(reader);
        }
        try {
            return CharStreams.toString(reader);
        }
        catch (IOException iOException) {
            this.junit4.log("Could not apply filters to " + string + ": " + Throwables.getStackTraceAsString(iOException), 1);
            return string;
        }
    }

    private FailureModel buildModel(FailureMirror failureMirror) {
        FailureModel failureModel = new FailureModel();
        failureModel.message = Strings.nullToEmpty(failureMirror.getMessage());
        failureModel.text = failureMirror.getTrace();
        failureModel.type = failureMirror.getThrowableClass();
        return failureModel;
    }

    private List buildModel(Map map) {
        ArrayList<PropertyModel> arrayList = new ArrayList<PropertyModel>();
        for (Map.Entry entry : map.entrySet()) {
            arrayList.add(new PropertyModel((String)entry.getKey(), (String)entry.getValue()));
        }
        return arrayList;
    }
}

