/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.commons.lang.ObjectUtils;
import org.carrot2.util.CloseableUtils;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;

public final class ServletContextLocator
implements IResourceLocator {
    private final ServletContext context;

    public ServletContextLocator(ServletContext servletContext) {
        assert (servletContext != null);
        this.context = servletContext;
    }

    @Override
    public IResource[] getAll(String resource) {
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        InputStream is = this.context.getResourceAsStream(resource);
        CloseableUtils.close((Closeable)is);
        if (is != null) {
            return new IResource[]{new WebAppResource(resource)};
        }
        return new IResource[0];
    }

    @Override
    public int hashCode() {
        return this.context.hashCode();
    }

    @Override
    public boolean equals(Object target) {
        if (target == this) {
            return true;
        }
        if (target != null && target instanceof ServletContextLocator) {
            return ObjectUtils.equals((Object)this.context, (Object)((ServletContextLocator)target).context);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + " [context: " + this.context + "]";
    }

    private final class WebAppResource
    implements IResource {
        private final String resource;

        public WebAppResource(String resource) {
            this.resource = resource;
        }

        @Override
        public InputStream open() throws IOException {
            return ServletContextLocator.this.context.getResourceAsStream(this.resource);
        }

        public String toString() {
            return "[webapp: " + this.resource + "]";
        }
    }
}

