/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.lingo;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.clustering.lingo.ClusterBuilderDescriptor;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.text.clustering.MultilingualClusteringDescriptor;
import org.carrot2.text.preprocessing.LabelFormatterDescriptor;
import org.carrot2.text.preprocessing.pipeline.IPreprocessingPipeline;
import org.carrot2.text.vsm.TermDocumentMatrixBuilderDescriptor;
import org.carrot2.text.vsm.TermDocumentMatrixReducerDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class LingoClusteringAlgorithmDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.clustering.lingo.LingoClusteringAlgorithm";
    public final String prefix = "LingoClusteringAlgorithm";
    public final String title = "Lingo clustering algorithm";
    public final String label = "Lingo Clustering";
    public final String description = "Implementation as described in: <i> \"Stanis\u0142aw Osi\u0144ski, Dawid Weiss: A Concept-Driven Algorithm for Clustering Search Results. IEEE Intelligent Systems, May/June, 3 (vol. 20), 2005, pp. 48\u201454.\"</i>.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "LingoClusteringAlgorithm";
    }

    public String getTitle() {
        return "Lingo clustering algorithm";
    }

    public String getLabel() {
        return "Lingo Clustering";
    }

    public String getDescription() {
        return "Implementation as described in: <i> \"Stanis\u0142aw Osi\u0144ski, Dawid Weiss: A Concept-Driven Algorithm for Clustering Search Results. IEEE Intelligent Systems, May/June, 3 (vol. 20), 2005, pp. 48\u201454.\"</i>.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(LingoClusteringAlgorithmDescriptor.attributes.query);
        ownAttrs.add(LingoClusteringAlgorithmDescriptor.attributes.documents);
        ownAttrs.add(LingoClusteringAlgorithmDescriptor.attributes.clusters);
        ownAttrs.add(LingoClusteringAlgorithmDescriptor.attributes.scoreWeight);
        ownAttrs.add(LingoClusteringAlgorithmDescriptor.attributes.desiredClusterCountBase);
        ownAttrs.add(LingoClusteringAlgorithmDescriptor.attributes.preprocessingPipeline);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(LingoClusteringAlgorithmDescriptor.attributes.query);
        allAttrs.add(LingoClusteringAlgorithmDescriptor.attributes.documents);
        allAttrs.add(LingoClusteringAlgorithmDescriptor.attributes.clusters);
        allAttrs.add(LingoClusteringAlgorithmDescriptor.attributes.scoreWeight);
        allAttrs.add(LingoClusteringAlgorithmDescriptor.attributes.desiredClusterCountBase);
        allAttrs.add(LingoClusteringAlgorithmDescriptor.attributes.preprocessingPipeline);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder query(String value) {
            this.map.put("query", value);
            return this;
        }

        public AttributeBuilder query(IObjectFactory<? extends String> value) {
            this.map.put("query", value);
            return this;
        }

        public AttributeBuilder documents(List<Document> value) {
            this.map.put("documents", value);
            return this;
        }

        public AttributeBuilder documents(IObjectFactory<? extends List<Document>> value) {
            this.map.put("documents", value);
            return this;
        }

        public List<Cluster> clusters() {
            return (List)this.map.get("clusters");
        }

        public AttributeBuilder scoreWeight(double value) {
            this.map.put("LingoClusteringAlgorithm.scoreWeight", value);
            return this;
        }

        public AttributeBuilder scoreWeight(IObjectFactory<? extends Double> value) {
            this.map.put("LingoClusteringAlgorithm.scoreWeight", value);
            return this;
        }

        public AttributeBuilder desiredClusterCountBase(int value) {
            this.map.put("LingoClusteringAlgorithm.desiredClusterCountBase", value);
            return this;
        }

        public AttributeBuilder desiredClusterCountBase(IObjectFactory<? extends Integer> value) {
            this.map.put("LingoClusteringAlgorithm.desiredClusterCountBase", value);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(IPreprocessingPipeline value) {
            this.map.put("LingoClusteringAlgorithm.preprocessingPipeline", value);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(Class<?> clazz) {
            this.map.put("LingoClusteringAlgorithm.preprocessingPipeline", clazz);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(IObjectFactory<? extends IPreprocessingPipeline> value) {
            this.map.put("LingoClusteringAlgorithm.preprocessingPipeline", value);
            return this;
        }

        public TermDocumentMatrixBuilderDescriptor.AttributeBuilder matrixBuilder() {
            return TermDocumentMatrixBuilderDescriptor.attributeBuilder(this.map);
        }

        public TermDocumentMatrixReducerDescriptor.AttributeBuilder matrixReducer() {
            return TermDocumentMatrixReducerDescriptor.attributeBuilder(this.map);
        }

        public ClusterBuilderDescriptor.AttributeBuilder clusterBuilder() {
            return ClusterBuilderDescriptor.attributeBuilder(this.map);
        }

        public LabelFormatterDescriptor.AttributeBuilder labelFormatter() {
            return LabelFormatterDescriptor.attributeBuilder(this.map);
        }

        public MultilingualClusteringDescriptor.AttributeBuilder multilingualClustering() {
            return MultilingualClusteringDescriptor.attributeBuilder(this.map);
        }
    }

    public static final class Attributes {
        public final AttributeInfo query;
        public final AttributeInfo documents;
        public final AttributeInfo clusters;
        public final AttributeInfo scoreWeight;
        public final AttributeInfo desiredClusterCountBase;
        public final AttributeInfo preprocessingPipeline;
        public final TermDocumentMatrixBuilderDescriptor.Attributes matrixBuilder;
        public final TermDocumentMatrixReducerDescriptor.Attributes matrixReducer;
        public final ClusterBuilderDescriptor.Attributes clusterBuilder;
        public final LabelFormatterDescriptor.Attributes labelFormatter;
        public final MultilingualClusteringDescriptor.Attributes multilingualClustering;

        private Attributes() {
            this.query = new AttributeInfo("query", "org.carrot2.clustering.lingo.LingoClusteringAlgorithm", "query", "Query that produced the documents. The query will help the algorithm to create\nbetter clusters. Therefore, providing the query is optional but desirable.", null, "Query that produced the documents", "The query will help the algorithm to create better clusters. Therefore, providing the query is optional but desirable.", null, null, CommonAttributesDescriptor.attributes.query);
            this.documents = new AttributeInfo("documents", "org.carrot2.clustering.lingo.LingoClusteringAlgorithm", "documents", "Documents to cluster.", null, "Documents to cluster", null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.clusters = new AttributeInfo("clusters", "org.carrot2.clustering.lingo.LingoClusteringAlgorithm", "clusters", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.clusters);
            this.scoreWeight = new AttributeInfo("LingoClusteringAlgorithm.scoreWeight", "org.carrot2.clustering.lingo.LingoClusteringAlgorithm", "scoreWeight", "Balance between cluster score and size during cluster sorting. Value equal to 0.0\nwill cause Lingo to sort clusters based only on cluster size. Value equal to 1.0\nwill cause Lingo to sort clusters based only on cluster score.", "Size-Score sorting ratio", "Balance between cluster score and size during cluster sorting", "Value equal to 0.0 will cause Lingo to sort clusters based only on cluster size. Value equal to 1.0 will cause Lingo to sort clusters based only on cluster score.", "Clusters", AttributeLevel.MEDIUM, null);
            this.desiredClusterCountBase = new AttributeInfo("LingoClusteringAlgorithm.desiredClusterCountBase", "org.carrot2.clustering.lingo.LingoClusteringAlgorithm", "desiredClusterCountBase", "Desired cluster count base. Base factor used to calculate the number of clusters\nbased on the number of documents on input. The larger the value, the more clusters\nwill be created. The number of clusters created by the algorithm will be\nproportional to the cluster count base, but not in a linear way.", "Cluster count base", "Desired cluster count base", "Base factor used to calculate the number of clusters based on the number of documents on input. The larger the value, the more clusters will be created. The number of clusters created by the algorithm will be proportional to the cluster count base, but not in a linear way.", "Clusters", AttributeLevel.BASIC, null);
            this.preprocessingPipeline = new AttributeInfo("LingoClusteringAlgorithm.preprocessingPipeline", "org.carrot2.clustering.lingo.LingoClusteringAlgorithm", "preprocessingPipeline", "Common preprocessing tasks handler, contains bindable attributes.", null, "Common preprocessing tasks handler, contains bindable attributes", null, null, AttributeLevel.ADVANCED, null);
            this.matrixBuilder = TermDocumentMatrixBuilderDescriptor.attributes;
            this.matrixReducer = TermDocumentMatrixReducerDescriptor.attributes;
            this.clusterBuilder = ClusterBuilderDescriptor.attributes;
            this.labelFormatter = LabelFormatterDescriptor.attributes;
            this.multilingualClustering = MultilingualClusteringDescriptor.attributes;
        }
    }

    public static class Keys {
        public static final String QUERY = "query";
        public static final String DOCUMENTS = "documents";
        public static final String CLUSTERS = "clusters";
        public static final String SCORE_WEIGHT = "LingoClusteringAlgorithm.scoreWeight";
        public static final String DESIRED_CLUSTER_COUNT_BASE = "LingoClusteringAlgorithm.desiredClusterCountBase";
        public static final String PREPROCESSING_PIPELINE = "LingoClusteringAlgorithm.preprocessingPipeline";

        protected Keys() {
        }
    }
}

