/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.reduction.DateMinFunction;
import org.apache.solr.analytics.function.reduction.DoubleMinFunction;
import org.apache.solr.analytics.function.reduction.FloatMinFunction;
import org.apache.solr.analytics.function.reduction.IntMinFunction;
import org.apache.solr.analytics.function.reduction.LongMinFunction;
import org.apache.solr.analytics.function.reduction.StringMinFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class MinFunction {
    public static final String name = "min";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The min function requires 1 paramater, " + params.length + " found.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof DateValueStream) {
            return new DateMinFunction((DateValueStream)param);
        }
        if (param instanceof IntValueStream) {
            return new IntMinFunction((IntValueStream)param);
        }
        if (param instanceof LongValueStream) {
            return new LongMinFunction((LongValueStream)param);
        }
        if (param instanceof FloatValueStream) {
            return new FloatMinFunction((FloatValueStream)param);
        }
        if (param instanceof DoubleValueStream) {
            return new DoubleMinFunction((DoubleValueStream)param);
        }
        if (param instanceof StringValueStream) {
            return new StringMinFunction((StringValueStream)param);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The min function requires a comparable parameter. Incorrect parameter: " + params[0].getExpressionStr());
    };
}

