/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute.constraint;

import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicInteger;
import org.carrot2.util.attribute.constraint.Constraint;
import org.carrot2.util.attribute.constraint.IntModulo;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="int-modulo")
class IntModuloConstraint
extends Constraint {
    @Attribute
    int modulo;
    @Attribute
    int offset;

    IntModuloConstraint() {
    }

    @Override
    protected boolean isMet(Object value) {
        if (value == null) {
            return false;
        }
        this.checkAssignableFrom(value, Byte.class, Short.class, Integer.class, AtomicInteger.class);
        Integer v = ((Number)value).intValue();
        return Math.abs(v % this.modulo) == this.offset;
    }

    public String toString() {
        return "modulo(modulo = " + this.modulo + ", offset = " + this.offset + ")";
    }

    @Override
    public void populateCustom(Annotation annotation) {
        IntModulo modulo = (IntModulo)annotation;
        this.modulo = modulo.modulo();
        this.offset = modulo.offset();
    }
}

