/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import org.apache.lucene.index.IndexCommit;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.snapshots.SolrSnapshotMetaDataManager;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.RefCounted;

class CreateSnapshotOp
implements CoreAdminHandler.CoreAdminOp {
    CreateSnapshotOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        CoreContainer cc = it.handler.getCoreContainer();
        SolrParams params = it.req.getParams();
        String commitName = params.required().get("commitName");
        String cname = params.required().get("core");
        try (SolrCore core = cc.getCore(cname);){
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to locate core " + cname);
            }
            String indexDirPath = core.getIndexDir();
            IndexCommit ic = core.getDeletionPolicy().getLatestCommit();
            if (ic == null) {
                RefCounted<SolrIndexSearcher> searcher = core.getSearcher();
                try {
                    ic = searcher.get().getIndexReader().getIndexCommit();
                }
                finally {
                    searcher.decref();
                }
            }
            SolrSnapshotMetaDataManager mgr = core.getSnapshotMetaDataManager();
            mgr.snapshot(commitName, indexDirPath, ic.getGeneration());
            it.rsp.add("core", core.getName());
            it.rsp.add("commitName", commitName);
            it.rsp.add("indexDirPath", indexDirPath);
            it.rsp.add("generation", ic.getGeneration());
            it.rsp.add("files", ic.getFileNames());
        }
    }
}

