/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.solr.client.solrj.cloud.autoscaling.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.cloud.autoscaling.NodeAddedTrigger;
import org.apache.solr.cloud.autoscaling.NodeLostTrigger;
import org.apache.solr.cloud.autoscaling.TriggerAction;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;

public class AutoScaling {
    public static final String AUTO_ADD_REPLICAS_TRIGGER_DSL = "    {        'name' : '.auto_add_replicas',        'event' : 'nodeLost',        'waitFor' : -1,        'enabled' : true,        'actions' : [            {                'name':'auto_add_replicas_plan',                'class':'solr.AutoAddReplicasPlanAction'            },            {                'name':'execute_plan',                'class':'solr.ExecutePlanAction'            }        ]    }";
    public static final Map<String, Object> AUTO_ADD_REPLICAS_TRIGGER_PROPS = (Map)Utils.fromJSONString((String)"    {        'name' : '.auto_add_replicas',        'event' : 'nodeLost',        'waitFor' : -1,        'enabled' : true,        'actions' : [            {                'name':'auto_add_replicas_plan',                'class':'solr.AutoAddReplicasPlanAction'            },            {                'name':'execute_plan',                'class':'solr.ExecutePlanAction'            }        ]    }");

    public static class TriggerFactoryImpl
    extends TriggerFactory {
        private final SolrCloudManager dataProvider;
        private final SolrResourceLoader loader;

        public TriggerFactoryImpl(SolrResourceLoader loader, SolrCloudManager dataProvider) {
            Objects.requireNonNull(dataProvider);
            Objects.requireNonNull(loader);
            this.dataProvider = dataProvider;
            this.loader = loader;
        }

        @Override
        public synchronized Trigger create(TriggerEventType type, String name, Map<String, Object> props) {
            if (this.isClosed) {
                throw new AlreadyClosedException("TriggerFactory has already been closed, cannot create new triggers");
            }
            switch (type) {
                case NODEADDED: {
                    return new NodeAddedTrigger(name, props, this.loader, this.dataProvider);
                }
                case NODELOST: {
                    return new NodeLostTrigger(name, props, this.loader, this.dataProvider);
                }
            }
            throw new IllegalArgumentException("Unknown event type: " + type + " in trigger: " + name);
        }
    }

    public static abstract class TriggerFactory
    implements Closeable {
        protected boolean isClosed = false;

        public abstract Trigger create(TriggerEventType var1, String var2, Map<String, Object> var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            TriggerFactory triggerFactory = this;
            synchronized (triggerFactory) {
                this.isClosed = true;
            }
        }
    }

    public static interface Trigger
    extends Closeable,
    Runnable {
        public String getName();

        public TriggerEventType getEventType();

        public boolean isEnabled();

        public Map<String, Object> getProperties();

        public int getWaitForSecond();

        public List<TriggerAction> getActions();

        public void setProcessor(TriggerEventProcessor var1);

        public TriggerEventProcessor getProcessor();

        public boolean isClosed();

        public void restoreState(Trigger var1);

        public void saveState();

        public void restoreState();

        public void init();
    }

    public static interface TriggerEventProcessor {
        public boolean process(TriggerEvent var1);
    }
}

