/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;

public class BatikStarElementBridge
extends SVGDecoratedShapeElementBridge
implements BatikExtConstants {
    @Override
    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    @Override
    public String getLocalName() {
        return "star";
    }

    @Override
    public Bridge getInstance() {
        return new BatikStarElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        String string = element.getAttributeNS(null, "cx");
        float f = 0.0f;
        if (string.length() != 0) {
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "cx", context);
        }
        string = element.getAttributeNS(null, "cy");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "cy", context);
        }
        if ((string = element.getAttributeNS(null, "r")).length() == 0) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"r", string});
        }
        float f3 = UnitProcessor.svgOtherLengthToUserSpace(string, "r", context);
        string = element.getAttributeNS(null, "ir");
        if (string.length() == 0) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"ir", string});
        }
        float f4 = UnitProcessor.svgOtherLengthToUserSpace(string, "ir", context);
        int n = BatikStarElementBridge.convertSides(element, "sides", 3, bridgeContext);
        GeneralPath generalPath = new GeneralPath();
        double d = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            double d2 = (double)i * d - 1.5707963267948966;
            double d3 = (double)f + (double)f4 * Math.cos(d2);
            double d4 = (double)f2 - (double)f4 * Math.sin(d2);
            if (i == 0) {
                generalPath.moveTo((float)d3, (float)d4);
            } else {
                generalPath.lineTo((float)d3, (float)d4);
            }
            d2 = ((double)i + 0.5) * d - 1.5707963267948966;
            d3 = (double)f + (double)f3 * Math.cos(d2);
            d4 = (double)f2 - (double)f3 * Math.sin(d2);
            generalPath.lineTo((float)d3, (float)d4);
        }
        generalPath.closePath();
        shapeNode.setShape(generalPath);
    }

    protected static int convertSides(Element element, String string, int n, BridgeContext bridgeContext) {
        String string2 = element.getAttributeNS(null, string);
        if (string2.length() == 0) {
            return n;
        }
        int n2 = 0;
        try {
            n2 = SVGUtilities.convertSVGInteger(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{string, string2});
        }
        if (n2 < 3) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{string, string2});
        }
        return n2;
    }
}

