/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditSourceOnDoubleClickHandler {
    private EditSourceOnDoubleClickHandler() {
    }

    public static void install(JTree tree, @Nullable Runnable whenPerformed) {
        new TreeMouseListener(tree, whenPerformed).installOn(tree);
    }

    public static void install(JTree tree) {
        EditSourceOnDoubleClickHandler.install(tree, null);
    }

    public static void install(final TreeTable treeTable) {
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(MouseEvent e) {
                if (ModalityState.current().dominates(ModalityState.NON_MODAL)) {
                    return false;
                }
                if (treeTable.getTree().getPathForLocation(e.getX(), e.getY()) == null) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(treeTable);
                Project project = CommonDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return false;
                }
                OpenSourceUtil.openSourcesFrom(dataContext, true);
                return true;
            }
        }.installOn(treeTable);
    }

    public static void install(final JTable table) {
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(MouseEvent e) {
                if (ModalityState.current().dominates(ModalityState.NON_MODAL)) {
                    return false;
                }
                if (table.columnAtPoint(e.getPoint()) < 0) {
                    return false;
                }
                if (table.rowAtPoint(e.getPoint()) < 0) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(table);
                Project project = CommonDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return false;
                }
                OpenSourceUtil.openSourcesFrom(dataContext, true);
                return true;
            }
        }.installOn(table);
    }

    public static void install(final JList list, final Runnable whenPerformed) {
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(MouseEvent e) {
                Point point = e.getPoint();
                int index = list.locationToIndex(point);
                if (index == -1) {
                    return false;
                }
                if (!list.getCellBounds(index, index).contains(point)) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(list);
                OpenSourceUtil.openSourcesFrom(dataContext, true);
                whenPerformed.run();
                return true;
            }
        }.installOn(list);
    }

    public static class TreeMouseListener
    extends DoubleClickListener {
        private final JTree myTree;
        @Nullable
        private final Runnable myWhenPerformed;

        public TreeMouseListener(JTree tree) {
            this(tree, null);
        }

        public TreeMouseListener(JTree tree, @Nullable Runnable whenPerformed) {
            this.myTree = tree;
            this.myWhenPerformed = whenPerformed;
        }

        @Override
        public boolean onDoubleClick(MouseEvent e) {
            TreePath clickPath;
            TreePath treePath = clickPath = this.myTree.getUI() instanceof WideSelectionTreeUI ? this.myTree.getClosestPathForLocation(e.getX(), e.getY()) : this.myTree.getPathForLocation(e.getX(), e.getY());
            if (clickPath == null) {
                return false;
            }
            DataContext dataContext = DataManager.getInstance().getDataContext(this.myTree);
            Project project = CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return false;
            }
            TreePath selectionPath = this.myTree.getSelectionPath();
            if (selectionPath == null || !clickPath.equals(selectionPath)) {
                return false;
            }
            Object last = selectionPath.getLastPathComponent();
            if (this.myTree.getModel().isLeaf(last) || this.myTree.getToggleClickCount() != e.getClickCount()) {
                this.processDoubleClick(e, dataContext, selectionPath);
                return true;
            }
            return false;
        }

        protected void processDoubleClick(@NotNull MouseEvent e, @NotNull DataContext dataContext, @NotNull TreePath treePath) {
            if (e == null) {
                TreeMouseListener.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                TreeMouseListener.$$$reportNull$$$0(1);
            }
            if (treePath == null) {
                TreeMouseListener.$$$reportNull$$$0(2);
            }
            OpenSourceUtil.openSourcesFrom(dataContext, true);
            if (this.myWhenPerformed != null) {
                this.myWhenPerformed.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "treePath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/EditSourceOnDoubleClickHandler$TreeMouseListener";
            objectArray[2] = "processDoubleClick";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

