/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.process.InterruptibleProcess;
import com.intellij.openapi.vcs.impl.CancellableRunnable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class ProcessWaiter<T extends CancellableRunnable> {
    protected T myInStreamListener;
    protected T myErrStreamListener;

    protected abstract T createStreamListener(InputStream var1);

    protected boolean tryReadStreams(int rc) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(InterruptibleProcess worker, long timeout) throws IOException, ExecutionException, TimeoutException, InterruptedException {
        int rc;
        this.myErrStreamListener = this.createStreamListener(worker.getErrorStream());
        this.myInStreamListener = this.createStreamListener(worker.getInputStream());
        Application app = ApplicationManager.getApplication();
        Future<?> errorStreamReadingFuture = null;
        Future<?> outputStreamReadingFuture = null;
        try {
            errorStreamReadingFuture = app.executeOnPooledThread((Runnable)this.myErrStreamListener);
            outputStreamReadingFuture = app.executeOnPooledThread((Runnable)this.myInStreamListener);
            rc = worker.execute();
            if (this.tryReadStreams(rc)) {
                errorStreamReadingFuture.get(timeout, TimeUnit.MILLISECONDS);
                outputStreamReadingFuture.get(timeout, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.cancelListeners();
            if (errorStreamReadingFuture != null) {
                errorStreamReadingFuture.cancel(true);
            }
            if (outputStreamReadingFuture != null) {
                outputStreamReadingFuture.cancel(true);
            }
        }
        return rc;
    }

    public void cancelListeners() {
        this.myErrStreamListener.cancel();
        this.myInStreamListener.cancel();
    }

    public T getInStreamListener() {
        return this.myInStreamListener;
    }

    public T getErrStreamListener() {
        return this.myErrStreamListener;
    }
}

