/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditSourceUtil {
    private EditSourceUtil() {
    }

    @Nullable
    public static Navigatable getDescriptor(@NotNull PsiElement element) {
        PsiElement original;
        if (element == null) {
            EditSourceUtil.$$$reportNull$$$0(0);
        }
        if ((original = EditSourceUtil.getNavigatableOriginalElement(element)) != null) {
            element = original;
        } else if (!EditSourceUtil.canNavigate(element)) {
            return null;
        }
        if (element instanceof PomTargetPsiElement) {
            return ((PomTargetPsiElement)element).getTarget();
        }
        PsiElement navigationElement = element.getNavigationElement();
        if (navigationElement instanceof PomTargetPsiElement) {
            return ((PomTargetPsiElement)navigationElement).getTarget();
        }
        int offset = navigationElement instanceof PsiFile ? -1 : navigationElement.getTextOffset();
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(navigationElement);
        if (virtualFile2 == null || !virtualFile2.isValid()) {
            return null;
        }
        OpenFileDescriptor desc = new OpenFileDescriptor(navigationElement.getProject(), virtualFile2, offset);
        desc.setUseCurrentWindow(FileEditorManager.USE_CURRENT_WINDOW.isIn((UserDataHolder)navigationElement));
        return desc;
    }

    private static PsiElement getNavigatableOriginalElement(@NotNull PsiElement element) {
        if (element == null) {
            EditSourceUtil.$$$reportNull$$$0(1);
        }
        List<? extends PsiElement> originalElements = EditSourceUtil.collectAllOriginalElements(element);
        for (PsiElement psiElement : originalElements) {
            if (!EditSourceUtil.canNavigate(psiElement)) continue;
            return psiElement;
        }
        return null;
    }

    public static boolean canNavigate(PsiElement element) {
        if (element == null || !element.isValid()) {
            return false;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile(element.getNavigationElement());
        return file != null && file.isValid() && !file.is(VFileProperty.SPECIAL) && !VfsUtilCore.isBrokenLink(file);
    }

    public static void navigate(@NotNull NavigationItem item, boolean requestFocus, boolean useCurrentWindow) {
        if (item == null) {
            EditSourceUtil.$$$reportNull$$$0(2);
        }
        if (item instanceof UserDataHolder) {
            ((UserDataHolder)item).putUserData(FileEditorManager.USE_CURRENT_WINDOW, (Object)useCurrentWindow);
        }
        item.navigate(requestFocus);
        if (item instanceof UserDataHolder) {
            ((UserDataHolder)item).putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        }
    }

    @NotNull
    private static List<? extends PsiElement> collectAllOriginalElements(@NotNull PsiElement element) {
        if (element == null) {
            EditSourceUtil.$$$reportNull$$$0(3);
        }
        List<? extends PsiElement> result = null;
        for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])GeneratedSourcesFilter.EP_NAME.getExtensions()) {
            result = EditSourceUtil.addAll(filter.getOriginalElements(element), result);
        }
        List list = (List)ObjectUtils.notNull(result, Collections.emptyList());
        if (list == null) {
            EditSourceUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static <T> List<T> addAll(@NotNull List<? extends T> elements, List<T> result) {
        if (elements == null) {
            EditSourceUtil.$$$reportNull$$$0(5);
        }
        if (result == null) {
            ArrayList arrayList = ContainerUtil.newArrayList(elements);
            if (arrayList == null) {
                EditSourceUtil.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        result.addAll(elements);
        List<T> list = result;
        if (list == null) {
            EditSourceUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/EditSourceUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/EditSourceUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllOriginalElements";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatableOriginalElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectAllOriginalElements";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

