/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvsExecution.ModalityContextImpl;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvsoperations.common.CvsCommandOperation;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsLog.LogOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.BranchesProvider;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsProvider;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.ui.SelectTagDialog;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.log.Revision;
import org.netbeans.lib.cvsclient.command.log.SymbolicName;

public class TagsHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsHelper");

    private TagsHelper() {
    }

    @Nullable
    public static String chooseBranch(TagsProvider tagsProvider, Project project) {
        try {
            CvsCommandOperation operation = tagsProvider.getOperation();
            if (operation == null) {
                return null;
            }
            BranchesProvider branchesProvider = TagsHelper.getBranchesProvider(operation, project);
            return TagsHelper.chooseFrom(branchesProvider.getAllBranches(), branchesProvider.getAllRevisions());
        }
        catch (VcsException e) {
            TagsHelper.showErrorMessage(e);
            return null;
        }
    }

    @Nullable
    public static String chooseBranch(Collection<FilePath> files, Project project) {
        try {
            return TagsHelper.chooseFrom(TagsHelper.collectAllBranches(files, project), new ArrayList<CvsRevisionNumber>());
        }
        catch (VcsException e) {
            TagsHelper.showErrorMessage(e);
            return null;
        }
    }

    public static void addChooseBranchAction(final TextFieldWithBrowseButton field, final Collection<FilePath> files, final Project project) {
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String branchName = TagsHelper.chooseBranch(files, project);
                if (branchName != null) {
                    field.setText(branchName);
                }
            }
        });
    }

    public static Collection<String> getAllBranches(List<LogInformation> log) {
        HashSet branches = new HashSet();
        for (LogInformation logInformation : log) {
            TagsHelper.collectBranches(logInformation, (HashSet<String>)branches);
        }
        return branches;
    }

    private static void collectBranches(LogInformation logInformation, HashSet<String> branches) {
        List allSymbolicNames = logInformation.getAllSymbolicNames();
        for (SymbolicName symbolicName : allSymbolicNames) {
            branches.add((Object)symbolicName.getName());
        }
    }

    private static void collectRevisions(LogInformation logInformation, ArrayList<CvsRevisionNumber> result) {
        for (Revision revision : logInformation.getRevisionList()) {
            result.add(new CvsRevisionNumber(revision.getNumber()));
        }
    }

    private static BranchesProvider getBranchesProvider(CvsOperation operation, Project project) throws VcsException {
        LOG.assertTrue(operation instanceof BranchesProvider);
        CvsOperationExecutor executor = new CvsOperationExecutor(true, project, new ModalityContextImpl(ModalityState.defaultModalityState()));
        CommandCvsHandler handler = new CommandCvsHandler(CvsBundle.message((String)"load.tags.operation.name", (Object[])new Object[0]), operation, true);
        executor.performActionSync(handler, CvsOperationExecutorCallback.EMPTY);
        CvsResult executionResult = executor.getResult();
        if (executionResult.hasErrors()) {
            throw executionResult.composeError();
        }
        return (BranchesProvider)((Object)operation);
    }

    public static Collection<FilePath> findVcsRoots(FilePath[] files, Project project) {
        if (files.length == 0) {
            return Collections.emptyList();
        }
        HashSet roots = new HashSet();
        HashSet seen = new HashSet();
        for (FilePath filePath : files) {
            VirtualFile root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(filePath);
            if (root == null || !seen.add(root)) continue;
            roots.add(VcsContextFactory.SERVICE.getInstance().createFilePathOn(root));
        }
        return roots;
    }

    private static Collection<String> collectAllBranches(Collection<FilePath> files, Project project) throws VcsException {
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        return TagsHelper.getBranchesProvider(new LogOperation(files), project).getAllBranches();
    }

    private static void showErrorMessage(VcsException e1) {
        Messages.showErrorDialog((String)CvsBundle.message((String)"error.message.cannot.load.tags", (Object[])new Object[]{e1.getLocalizedMessage()}), (String)CvsBundle.message((String)"operation.name.select.tag", (Object[])new Object[0]));
    }

    @Nullable
    private static String chooseFrom(Collection<String> tags, Collection<CvsRevisionNumber> revisions) {
        if (tags == null) {
            return null;
        }
        Collection<String> revisionsNames = TagsHelper.collectSortedRevisionsNames(revisions);
        if (tags.isEmpty() && revisionsNames.isEmpty()) {
            Messages.showMessageDialog((String)CvsBundle.message((String)"message.no.tags.found", (Object[])new Object[0]), (String)CvsBundle.message((String)"operation.name.select.tag", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            return null;
        }
        SelectTagDialog selectTagDialog = new SelectTagDialog(TagsHelper.collectSortedTags(tags), revisionsNames);
        if (selectTagDialog.showAndGet()) {
            return selectTagDialog.getTag();
        }
        return null;
    }

    private static Collection<String> collectSortedTags(Collection<String> tags) {
        ArrayList<String> result = new ArrayList<String>(tags);
        Collections.sort(result);
        return result;
    }

    private static Collection<String> collectSortedRevisionsNames(Collection<CvsRevisionNumber> revisions) {
        if (revisions == null) {
            return new ArrayList<String>();
        }
        ArrayList<CvsRevisionNumber> list = new ArrayList<CvsRevisionNumber>(revisions);
        Collections.sort(list, (o, o1) -> o.compareTo((VcsRevisionNumber)o1));
        ArrayList<String> result = new ArrayList<String>();
        for (CvsRevisionNumber aList : list) {
            result.add(aList.toString());
        }
        return result;
    }

    public static Collection<CvsRevisionNumber> getAllRevisions(List<LogInformation> logs) {
        ArrayList<CvsRevisionNumber> result = new ArrayList<CvsRevisionNumber>();
        for (LogInformation log : logs) {
            TagsHelper.collectRevisions(log, result);
        }
        return result;
    }
}

