/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.changeBrowser;

import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.changeBrowser.CvsContentRevision;
import com.intellij.cvsSupport2.changeBrowser.RevisionWrapper;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.SimpleRevision;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.command.log.Revision;

public class CvsChangeList
implements CommittedChangeList {
    private long myDate;
    private long myFinishDate;
    private long myNumber;
    @NotNull
    private String myDescription;
    private final VirtualFile myRootFile;
    private String myRootPath;
    private final List<RevisionWrapper> myRevisions;
    private String myUser;
    public static final int SUITABLE_DIFF = 120000;
    private final CvsEnvironment myEnvironment;
    private final Project myProject;
    private List<Change> myChanges;
    @NonNls
    private static final String EXP_STATE = "Exp";
    @NonNls
    private static final String ADDED_STATE = "added";
    @NonNls
    public static final String DEAD_STATE = "dead";

    /*
     * WARNING - void declaration
     */
    public CvsChangeList(Project project, CvsEnvironment environment, @Nullable VirtualFile rootFile, long number, @NotNull String description, long date, String string, String string2) {
        void rootPath;
        void user;
        if (description == null) {
            CvsChangeList.$$$reportNull$$$0(0);
        }
        this.myRevisions = new ArrayList<RevisionWrapper>();
        this.myRootFile = rootFile;
        this.myDate = date;
        this.myFinishDate = date;
        this.myNumber = number;
        this.myDescription = description;
        this.myUser = user;
        this.myRootPath = rootPath;
        this.myEnvironment = environment;
        this.myProject = project;
    }

    public CvsChangeList(Project project, CvsEnvironment environment, @Nullable VirtualFile rootFile, DataInput stream) throws IOException {
        this.myRevisions = new ArrayList<RevisionWrapper>();
        this.myProject = project;
        this.myEnvironment = environment;
        this.myRootFile = rootFile;
        this.readFromStream(stream);
    }

    public String getCommitterName() {
        return this.myUser;
    }

    public Date getCommitDate() {
        return new Date(this.myDate);
    }

    public long getNumber() {
        return this.myNumber;
    }

    public AbstractVcs getVcs() {
        return CvsVcs2.getInstance(this.myProject);
    }

    public boolean isModifiable() {
        return true;
    }

    public void setDescription(String newMessage) {
        this.myDescription = newMessage;
    }

    @Nullable
    public String getBranch() {
        if (this.myRevisions.size() > 0) {
            return this.myRevisions.get(0).getBranch();
        }
        return null;
    }

    public Collection<Change> getChanges() {
        if (this.myChanges == null) {
            this.myChanges = new ArrayList<Change>();
            for (RevisionWrapper wrapper : this.myRevisions) {
                File localFile;
                Revision revision = wrapper.getRevision();
                String state = revision.getState();
                String path = wrapper.getFile();
                if (this.myRootFile != null) {
                    String directorySuffix;
                    String string = directorySuffix = this.myRootFile.isDirectory() ? "/" : "";
                    if (StringUtil.startsWithConcatenation((String)path, (String[])new String[]{this.myRootPath, directorySuffix})) {
                        path = path.substring(this.myRootPath.length() + directorySuffix.length());
                        localFile = new File(this.myRootFile.getPresentableUrl(), path);
                    } else {
                        localFile = new File(wrapper.getFile());
                    }
                } else {
                    localFile = new File(wrapper.getFile());
                }
                boolean added = CvsChangeList.isAdded(revision);
                CvsContentRevision beforeRevision = added ? null : new CvsContentRevision(new File(wrapper.getFile()), localFile, new SimpleRevision(new CvsRevisionNumber(revision.getNumber()).getPrevNumber().asString()), this.myEnvironment, this.myProject);
                CvsContentRevision afterRevision = !added && DEAD_STATE.equals(state) ? null : new CvsContentRevision(new File(wrapper.getFile()), localFile, new SimpleRevision(revision.getNumber()), this.myEnvironment, this.myProject);
                this.myChanges.add(new Change((ContentRevision)beforeRevision, (ContentRevision)afterRevision));
            }
        }
        return this.myChanges;
    }

    @NotNull
    public String getName() {
        String string = this.myDescription;
        if (string == null) {
            CvsChangeList.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String getComment() {
        return this.myDescription;
    }

    public boolean containsDate(long date) {
        if (date >= this.myDate && date <= this.myFinishDate) {
            return true;
        }
        if (Math.abs(date - this.myDate) < 120000L) {
            return true;
        }
        return Math.abs(date - this.myFinishDate) < 120000L;
    }

    public boolean containsFile(String file) {
        for (RevisionWrapper revision : this.myRevisions) {
            if (!revision.getFile().equals(file)) continue;
            return true;
        }
        return false;
    }

    public void addFileRevision(RevisionWrapper revision) {
        this.myRevisions.add(revision);
        long revisionTime = revision.getTime();
        if (revisionTime < this.myDate) {
            this.myDate = revisionTime;
        }
        if (revisionTime > this.myFinishDate) {
            this.myFinishDate = revisionTime;
        }
    }

    public boolean containsFileRevision(RevisionWrapper revision) {
        return this.myRevisions.contains(revision);
    }

    private static boolean isAdded(Revision revision) {
        String revisionState = revision.getState();
        if (EXP_STATE.equals(revisionState) && revision.getLines() == null) {
            return true;
        }
        if (ADDED_STATE.equals(revisionState)) {
            return true;
        }
        int[] subRevisions = new CvsRevisionNumber(revision.getNumber()).getSubRevisions();
        return subRevisions != null && subRevisions.length > 2 && subRevisions[subRevisions.length - 1] == 1;
    }

    public static boolean isAncestor(String parent, String child) {
        return child.equals(parent) || StringUtil.startsWithConcatenation((String)child, (String[])new String[]{parent, "/"});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CvsChangeList that = (CvsChangeList)o;
        return this.myRevisions.equals(that.myRevisions);
    }

    public int hashCode() {
        int result = (int)(this.myNumber ^ this.myNumber >>> 32);
        result = 31 * result + this.myDescription.hashCode();
        return result;
    }

    public String toString() {
        return this.myDescription;
    }

    public void writeToStream(DataOutput stream) throws IOException {
        stream.writeLong(this.myDate);
        stream.writeLong(this.myFinishDate);
        stream.writeLong(this.myNumber);
        IOUtil.writeUTFTruncated((DataOutput)stream, (String)this.myDescription);
        stream.writeUTF(this.myUser);
        stream.writeUTF(this.myRootPath);
        stream.writeInt(this.myRevisions.size());
        for (RevisionWrapper revision : this.myRevisions) {
            revision.writeToStream(stream);
        }
    }

    private void readFromStream(DataInput stream) throws IOException {
        this.myDate = stream.readLong();
        this.myFinishDate = stream.readLong();
        this.myNumber = stream.readLong();
        this.myDescription = stream.readUTF();
        this.myUser = stream.readUTF();
        this.myRootPath = stream.readUTF();
        int revisionCount = stream.readInt();
        for (int i = 0; i < revisionCount; ++i) {
            this.myRevisions.add(RevisionWrapper.readFromStream(stream));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cvsSupport2/changeBrowser/CvsChangeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cvsSupport2/changeBrowser/CvsChangeList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

