/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.update;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.AbstractMessageParser;
import org.netbeans.lib.cvsclient.command.update.UpdateFileInfo;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEntryListener;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class UpdateMessageParser
extends AbstractMessageParser
implements IEntryListener {
    @NonNls
    private static final String EXAM_DIR = "server: Updating ";
    @NonNls
    private static final String UNKNOWN = "server: nothing known about";
    @NonNls
    private static final String TO_ADD = "server: use `cvs add' to create an entry for";
    @NonNls
    private static final String STATES = "UPARMC?";
    @NonNls
    private static final String WARNING = "server: warning: ";
    @NonNls
    private static final String PERTINENT = "is not (any longer) pertinent";
    @NonNls
    private static final String MERGING = "Merging differences between ";
    @NonNls
    private static final Pattern NOT_IN_REPOSITORY_PATTERN = Pattern.compile("cvs .+: (.+) is no longer in the repository");
    @NonNls
    private static final String LOCALLY_MODIFIED_FILE_HAS_BEEN_REMOVED = "is locally modified, but has been removed in revision";
    private final IEventSender eventManager;
    private final ICvsFileSystem cvsFileSystem;
    private UpdateFileInfo fileInfo;

    public UpdateMessageParser(IEventSender eventManager, ICvsFileSystem cvsFileSystem) {
        BugLog.getInstance().assertNotNull(eventManager);
        BugLog.getInstance().assertNotNull(cvsFileSystem);
        this.eventManager = eventManager;
        this.cvsFileSystem = cvsFileSystem;
    }

    @Override
    public void registerListeners(ICvsListenerRegistry listenerRegistry) {
        super.registerListeners(listenerRegistry);
        listenerRegistry.addEntryListener(this);
    }

    @Override
    public void unregisterListeners(ICvsListenerRegistry listenerRegistry) {
        listenerRegistry.removeEntryListener(this);
        super.unregisterListeners(listenerRegistry);
    }

    @Override
    protected void outputDone() {
        if (this.fileInfo == null) {
            return;
        }
        if (this.fileInfo.getType() != null) {
            this.eventManager.notifyFileInfoListeners(this.fileInfo);
        }
        this.fileInfo = null;
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        String firstChar;
        if (line.startsWith("RCS file:")) {
            return;
        }
        if (line.startsWith("retrieving revision ")) {
            return;
        }
        if (line.indexOf(" already contains the differences between ") > 0) {
            return;
        }
        if (line.startsWith("rcsmerge: warning: conflicts during merge")) {
            return;
        }
        if (line.indexOf(EXAM_DIR) >= 0) {
            return;
        }
        if (line.indexOf(": conflicts found in ") > 0) {
            return;
        }
        int index = line.indexOf(UNKNOWN);
        if (index >= 0) {
            String fileName = line.substring(index + UNKNOWN.length()).trim();
            this.processUnknown(fileName);
            return;
        }
        index = line.indexOf(TO_ADD);
        if (index >= 0) {
            String fileName = line.substring(index + TO_ADD.length()).trim();
            this.processUnknown(fileName);
            return;
        }
        if (line.startsWith(MERGING)) {
            return;
        }
        index = line.indexOf(LOCALLY_MODIFIED_FILE_HAS_BEEN_REMOVED);
        if (index >= 0) {
            String warningPrefix = "cvs server: file ";
            if (!line.startsWith(warningPrefix)) {
                return;
            }
            String fileName = line.substring(warningPrefix.length(), index).trim();
            FileObject fileObject = this.cvsFileSystem.unixFileNameToFileObject(fileName);
            this.ensureExistingFileInfoContainer(fileObject);
            this.fileInfo.setType("C");
            return;
        }
        index = line.indexOf(WARNING);
        if (index >= 0) {
            int pertinentIndex = line.indexOf(PERTINENT);
            if (pertinentIndex > 0) {
                String fileName = line.substring(index + WARNING.length(), pertinentIndex).trim();
                FileObject fileObject = this.cvsFileSystem.unixFileNameToFileObject(fileName);
                this.processNotPertinent(fileObject);
            }
            return;
        }
        Matcher m = NOT_IN_REPOSITORY_PATTERN.matcher(line);
        if (m.matches()) {
            String fileName = m.group(1).trim();
            FileObject fileObject = this.cvsFileSystem.unixFileNameToFileObject(fileName);
            this.processNotPertinent(fileObject);
            return;
        }
        if (line.length() > 2 && line.charAt(1) == ' ' && STATES.indexOf(firstChar = line.substring(0, 1)) >= 0) {
            this.processFile(line.substring(2), firstChar);
        }
    }

    @Override
    public void gotEntry(FileObject fileObject, Entry entry) {
        this.ensureExistingFileInfoContainer(fileObject);
        this.fileInfo.setEntry(entry);
    }

    private void ensureExistingFileInfoContainer(FileObject fileObject) {
        if (this.fileInfo != null) {
            if (fileObject.equals(this.fileInfo.getFileObject())) {
                return;
            }
            this.outputDone();
        }
        this.fileInfo = new UpdateFileInfo(fileObject, this.cvsFileSystem.getLocalFileSystem().getFile(fileObject));
    }

    private void processUnknown(String fileName) {
        FileObject fileObject = this.cvsFileSystem.unixFileNameToFileObject(fileName);
        this.ensureExistingFileInfoContainer(fileObject);
        this.fileInfo.setType("?");
    }

    private void processFile(String fileName, String type) {
        FileObject fileObject = this.cvsFileSystem.unixFileNameToFileObject(fileName);
        this.ensureExistingFileInfoContainer(fileObject);
        this.fileInfo.setType(type);
    }

    private void processNotPertinent(FileObject fileObject) {
        this.ensureExistingFileInfoContainer(fileObject);
        this.fileInfo.setType("Y");
    }

    @Override
    public void binaryMessageSent(byte[] bytes) {
    }
}

