/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CvsFiles;
import org.netbeans.lib.cvsclient.command.FileSystemScanner;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.ICvsFilesVisitor;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.request.Requests;
import org.netbeans.lib.cvsclient.util.BugLog;

public abstract class AbstractCommand
extends Command {
    private final List<AbstractFileObject> fileObjects = new ArrayList<AbstractFileObject>();
    private boolean recursive = true;

    protected AbstractCommand() {
    }

    protected final boolean isRecursive() {
        return this.recursive;
    }

    public final void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void addFileObject(@NotNull AbstractFileObject file) {
        if (file == null) {
            AbstractCommand.$$$reportNull$$$0(0);
        }
        this.fileObjects.add(file);
    }

    public final List<AbstractFileObject> getFileObjects() {
        return Collections.unmodifiableList(this.fileObjects);
    }

    protected final void addArgumentRequests(Requests requests) {
        for (AbstractFileObject fileObject : this.fileObjects) {
            requests.addFileArgumentRequest(fileObject);
        }
    }

    protected final ICvsFiles scanFileSystem(IClientEnvironment clientEnvironment) throws IOException {
        CvsFiles cvsFiles = new CvsFiles();
        new FileSystemScanner(clientEnvironment, this.isRecursive()).scan(this.getFileObjects(), cvsFiles);
        return cvsFiles;
    }

    protected final void addFileRequests(ICvsFiles cvsFiles, final Requests requests, final IClientEnvironment clientEnvironment) {
        cvsFiles.visit(new ICvsFilesVisitor(){

            @Override
            public void handleFile(FileObject fileObject, Entry entry, boolean exists) {
                AbstractCommand.this.addRequestForFile(fileObject, entry, exists, requests, clientEnvironment);
            }

            @Override
            public void handleDirectory(DirectoryObject directoryObject) {
                requests.addDirectoryStickyRequests(directoryObject, clientEnvironment.getAdminReader(), clientEnvironment.getCvsFileSystem());
            }
        });
    }

    protected void addRequestForFile(FileObject fileObject, Entry entry, boolean fileExists, Requests requests, IClientEnvironment clientEnvironment) {
        BugLog.getInstance().assertNotNull(fileObject);
        BugLog.getInstance().assertNotNull(requests);
        BugLog.getInstance().assertNotNull(clientEnvironment);
        if (entry == null) {
            if (!clientEnvironment.getIgnoreFileFilter().shouldBeIgnored(fileObject, clientEnvironment.getCvsFileSystem())) {
                requests.addQuestionableRequest(fileObject);
            }
            return;
        }
        if (entry.isAddedFile() && !fileExists) {
            return;
        }
        Date entryLastModified = entry.getLastModified();
        boolean hadConflicts = entry.isConflict();
        if (!hadConflicts) {
            entry.parseConflictString(null);
        }
        requests.addEntryRequest(entry);
        if (!fileExists || entry.isRemoved()) {
            return;
        }
        if (!hadConflicts && entryLastModified != null && !this.isModified(fileObject, entryLastModified, clientEnvironment)) {
            requests.addUnchangedRequest(fileObject);
            return;
        }
        this.addModifiedRequest(fileObject, entry, requests, clientEnvironment);
    }

    protected boolean isModified(FileObject fileObject, Date entryLastModified, IClientEnvironment clientEnvironment) {
        return clientEnvironment.getAdminReader().isModified(fileObject, entryLastModified, clientEnvironment.getCvsFileSystem());
    }

    protected void addModifiedRequest(FileObject fileObject, Entry entry, Requests requests, IClientEnvironment clientEnvironment) {
        boolean writable = clientEnvironment.getLocalFileReader().isWritable(fileObject, clientEnvironment.getCvsFileSystem());
        requests.addModifiedRequest(fileObject, entry.isBinary(), writable);
    }

    protected final void appendFileArguments(StringBuffer buffer) {
        boolean appendSpace = false;
        for (AbstractFileObject fileObject : this.fileObjects) {
            if (appendSpace) {
                buffer.append(' ');
            }
            buffer.append(fileObject.toUnixPath());
            appendSpace = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/netbeans/lib/cvsclient/command/AbstractCommand", "addFileObject"));
    }
}

