/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Consumer;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitLogOutputSplitter
implements GitLineHandlerListener {
    private static final int OUTPUT_CAPACITY_THRESHOLD = 5000000;
    @NotNull
    private final GitLineHandler myHandler;
    @NotNull
    private final Consumer<StringBuilder> myRecordConsumer;
    @NotNull
    private final StringBuilder myOutput;
    @NotNull
    private final StringBuilder myErrors;
    @Nullable
    private VcsException myException;
    private boolean myIsInsideBody;

    public GitLogOutputSplitter(@NotNull GitLineHandler handler, @NotNull Consumer<StringBuilder> recordConsumer) {
        if (handler == null) {
            GitLogOutputSplitter.$$$reportNull$$$0(0);
        }
        if (recordConsumer == null) {
            GitLogOutputSplitter.$$$reportNull$$$0(1);
        }
        this.myOutput = new StringBuilder();
        this.myErrors = new StringBuilder();
        this.myException = null;
        this.myIsInsideBody = true;
        this.myHandler = handler;
        this.myRecordConsumer = recordConsumer;
        this.myHandler.addLineListener(this);
    }

    @Override
    public void onLineAvailable(String line, Key outputType) {
        if (outputType == ProcessOutputTypes.STDERR) {
            this.myErrors.append(line).append("\n");
        } else if (outputType == ProcessOutputTypes.STDOUT) {
            try {
                this.processOutputLine(line);
            }
            catch (Exception e) {
                this.myException = new VcsException((Throwable)e);
            }
        }
    }

    private void processOutputLine(@NotNull String line) {
        if (line == null) {
            GitLogOutputSplitter.$$$reportNull$$$0(2);
        }
        if (this.myIsInsideBody) {
            int bodyEnd = line.indexOf("\u0003\u0003");
            if (bodyEnd >= 0) {
                this.myIsInsideBody = false;
                this.myOutput.append(line.substring(0, bodyEnd + "\u0003\u0003".length()));
                this.processOutputLine(line.substring(bodyEnd + "\u0003\u0003".length()));
            } else {
                this.myOutput.append(line).append("\n");
            }
        } else {
            int nextRecordStart = line.indexOf("\u0001\u0001");
            if (nextRecordStart >= 0) {
                this.myOutput.append(line.substring(0, nextRecordStart));
                this.myRecordConsumer.consume((Object)this.myOutput);
                this.myOutput.setLength(0);
                if (this.myOutput.capacity() >= 5000000) {
                    this.myOutput.trimToSize();
                }
                this.myIsInsideBody = true;
                this.processOutputLine(line.substring(nextRecordStart));
            } else {
                this.myOutput.append(line).append("\n");
            }
        }
    }

    public void processTerminated(int exitCode) {
        if (exitCode != 0) {
            String errorMessage = this.myErrors.toString();
            if (errorMessage.isEmpty()) {
                errorMessage = GitBundle.message("git.error.exit", exitCode);
            }
            this.myException = new VcsException(errorMessage + "\nCommand line: [" + this.myHandler.printableCommandLine() + "]");
        } else {
            try {
                this.myRecordConsumer.consume((Object)this.myOutput);
            }
            catch (Exception e) {
                this.myException = new VcsException((Throwable)e);
            }
        }
    }

    public void startFailed(Throwable exception) {
        this.myException = new VcsException(exception);
    }

    public void reportErrors() throws VcsException {
        if (this.myException != null) {
            if (this.myException.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)this.myException.getCause();
            }
            throw this.myException;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "git4idea/history/GitLogOutputSplitter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processOutputLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

