/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CheckoutProviderEx;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.actions.BasicAction;
import git4idea.checkout.GitCloneDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCheckoutProvider
extends CheckoutProviderEx {
    private final Git myGit;

    public GitCheckoutProvider(@NotNull Git git) {
        if (git == null) {
            GitCheckoutProvider.$$$reportNull$$$0(0);
        }
        this.myGit = git;
    }

    public String getVcsName() {
        return "_Git";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener2, @Nullable String predefinedRepositoryUrl) {
        if (project == null) {
            GitCheckoutProvider.$$$reportNull$$$0(1);
        }
        BasicAction.saveAll();
        GitCloneDialog dialog = new GitCloneDialog(project, predefinedRepositoryUrl);
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.rememberSettings();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        File parent = new File(dialog.getParentDirectory());
        VirtualFile destinationParent = lfs.findFileByIoFile(parent);
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent);
        }
        if (destinationParent == null) {
            return;
        }
        String sourceRepositoryURL = dialog.getSourceRepositoryURL();
        String directoryName = dialog.getDirectoryName();
        String parentDirectory = dialog.getParentDirectory();
        GitCheckoutProvider.clone(project, this.myGit, listener2, destinationParent, sourceRepositoryURL, directoryName, parentDirectory);
    }

    public static void clone(final Project project, final @NotNull Git git, final CheckoutProvider.Listener listener2, final VirtualFile destinationParent, final String sourceRepositoryURL, final String directoryName, final String parentDirectory) {
        if (git == null) {
            GitCheckoutProvider.$$$reportNull$$$0(2);
        }
        final AtomicBoolean cloneResult = new AtomicBoolean();
        new Task.Backgroundable(project, DvcsBundle.message((String)"cloning.repository", (Object[])new Object[]{sourceRepositoryURL})){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                cloneResult.set(GitCheckoutProvider.doClone(project, git, directoryName, parentDirectory, sourceRepositoryURL));
            }

            public void onSuccess() {
                if (!cloneResult.get()) {
                    return;
                }
                DvcsUtil.addMappingIfSubRoot((Project)project, (String)FileUtil.join((String[])new String[]{parentDirectory, directoryName}), (String)"Git");
                destinationParent.refresh(true, true, () -> {
                    if (project.isOpen() && !project.isDisposed() && !project.isDefault()) {
                        VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)project);
                        mgr.fileDirty(destinationParent);
                    }
                });
                listener2.directoryCheckedOut(new File(parentDirectory, directoryName), GitVcs.getKey());
                listener2.checkoutCompleted();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/checkout/GitCheckoutProvider$1", "run"));
            }
        }.queue();
    }

    public static boolean doClone(@NotNull Project project, @NotNull Git git, @NotNull String directoryName, @NotNull String parentDirectory, @NotNull String sourceRepositoryURL) {
        if (project == null) {
            GitCheckoutProvider.$$$reportNull$$$0(3);
        }
        if (git == null) {
            GitCheckoutProvider.$$$reportNull$$$0(4);
        }
        if (directoryName == null) {
            GitCheckoutProvider.$$$reportNull$$$0(5);
        }
        if (parentDirectory == null) {
            GitCheckoutProvider.$$$reportNull$$$0(6);
        }
        if (sourceRepositoryURL == null) {
            GitCheckoutProvider.$$$reportNull$$$0(7);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setIndeterminate(false);
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(indicator);
        GitCommandResult result2 = git.clone(project, new File(parentDirectory), sourceRepositoryURL, directoryName, progressListener);
        if (result2.success()) {
            return true;
        }
        VcsNotifier.getInstance((Project)project).notifyError("Clone failed", result2.getErrorOutputAsHtmlString());
        return false;
    }

    @NotNull
    public String getVcsId() {
        if ("git" == null) {
            GitCheckoutProvider.$$$reportNull$$$0(8);
        }
        return "git";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener2) {
        if (project == null) {
            GitCheckoutProvider.$$$reportNull$$$0(9);
        }
        this.doCheckout(project, listener2, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirectory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRepositoryURL";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/checkout/GitCheckoutProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/checkout/GitCheckoutProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCheckout";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doClone";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

