/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsUser;
import git4idea.GitVcs;
import git4idea.config.GitConfigUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUserRegistry
implements Disposable,
VcsListener {
    private static final Logger LOG = Logger.getInstance(GitUserRegistry.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final VcsLogObjectsFactory myFactory;
    @NotNull
    private final Map<VirtualFile, VcsUser> myUserMap;

    public GitUserRegistry(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager, @NotNull VcsLogObjectsFactory factory) {
        if (project == null) {
            GitUserRegistry.$$$reportNull$$$0(0);
        }
        if (vcsManager == null) {
            GitUserRegistry.$$$reportNull$$$0(1);
        }
        if (factory == null) {
            GitUserRegistry.$$$reportNull$$$0(2);
        }
        this.myUserMap = ContainerUtil.newConcurrentMap();
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.myFactory = factory;
    }

    public static GitUserRegistry getInstance(@NotNull Project project) {
        if (project == null) {
            GitUserRegistry.$$$reportNull$$$0(3);
        }
        return (GitUserRegistry)ServiceManager.getService((Project)project, GitUserRegistry.class);
    }

    public void activate() {
        this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
        this.directoryMappingChanged();
    }

    @Nullable
    public VcsUser getUser(@NotNull VirtualFile root) {
        if (root == null) {
            GitUserRegistry.$$$reportNull$$$0(4);
        }
        return this.myUserMap.get(root);
    }

    @Nullable
    public VcsUser getOrReadUser(@NotNull VirtualFile root) {
        VcsUser user;
        if (root == null) {
            GitUserRegistry.$$$reportNull$$$0(5);
        }
        if ((user = this.myUserMap.get(root)) == null) {
            try {
                user = this.readCurrentUser(this.myProject, root);
                if (user != null) {
                    this.myUserMap.put(root, user);
                }
            }
            catch (VcsException e) {
                LOG.warn("Could not retrieve user name in " + root, (Throwable)e);
            }
        }
        return user;
    }

    @Nullable
    private VcsUser readCurrentUser(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        if (project == null) {
            GitUserRegistry.$$$reportNull$$$0(6);
        }
        if (root == null) {
            GitUserRegistry.$$$reportNull$$$0(7);
        }
        String userName = GitConfigUtil.getValue(project, root, "user.name");
        String userEmail = StringUtil.notNullize((String)GitConfigUtil.getValue(project, root, "user.email"));
        return userName == null ? null : this.myFactory.createUser(userName, userEmail);
    }

    public void dispose() {
        this.myUserMap.clear();
    }

    public void directoryMappingChanged() {
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        if (vcs == null) {
            return;
        }
        Object[] roots = this.myVcsManager.getRootsUnderVcs((AbstractVcs)vcs);
        List rootsToCheck = ContainerUtil.filter((Object[])roots, root -> this.getUser((VirtualFile)root) == null);
        if (!rootsToCheck.isEmpty()) {
            Runnable task = () -> {
                for (VirtualFile root : rootsToCheck) {
                    this.getOrReadUser(root);
                }
            };
            BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, (Runnable)task);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "git4idea/GitUserRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getUser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrReadUser";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "readCurrentUser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

