/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import icons.PythonIcons;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0014H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "Ljavax/swing/JPanel;", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "nameExtensionComponent", "Ljavax/swing/JComponent;", "getNameExtensionComponent", "()Ljavax/swing/JComponent;", "newProjectPath", "", "getNewProjectPath", "()Ljava/lang/String;", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "getOrCreateSdk", "validateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "Companion", "python-community"})
public abstract class PyAddSdkPanel
extends JPanel {
    @NotNull
    private final Icon icon;
    @Nullable
    private final Sdk sdk;
    @Nullable
    private final JComponent nameExtensionComponent;
    @Nullable
    private String newProjectPath;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String getPanelName();

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Nullable
    public Sdk getSdk() {
        return this.sdk;
    }

    @Nullable
    public JComponent getNameExtensionComponent() {
        return this.nameExtensionComponent;
    }

    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    public void setNewProjectPath(@Nullable String string) {
        this.newProjectPath = string;
    }

    @Nullable
    public Sdk getOrCreateSdk() {
        return this.getSdk();
    }

    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.emptyList();
    }

    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
    }

    public PyAddSdkPanel() {
        Icon icon = PythonIcons.Python.Python;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PythonIcons.Python.Python");
        this.icon = icon;
    }

    @JvmStatic
    @Nullable
    protected static final ValidationInfo validateEmptyOrNonExistingDirectoryLocation(@NotNull TextFieldWithBrowseButton field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        return Companion.validateEmptyOrNonExistingDirectoryLocation(field);
    }

    @JvmStatic
    @Nullable
    protected static final ValidationInfo validateAnacondaPresense(@Nullable JComponent component) {
        return Companion.validateAnacondaPresense(component);
    }

    @JvmStatic
    @Nullable
    protected static final ValidationInfo validateSdkComboBox(@NotNull PySdkPathChoosingComboBox field) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        return Companion.validateSdkComboBox(field);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0005J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u000bH\u0005\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddSdkPanel$Companion;", "", "()V", "validateAnacondaPresense", "Lcom/intellij/openapi/ui/ValidationInfo;", "component", "Ljavax/swing/JComponent;", "validateEmptyOrNonExistingDirectoryLocation", "field", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "validateSdkComboBox", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "python-community"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        protected final ValidationInfo validateEmptyOrNonExistingDirectoryLocation(@NotNull TextFieldWithBrowseButton field) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
            String text = field.getText();
            File file2 = new File(text);
            if (StringUtil.isEmptyOrSpaces((String)text)) {
                string = "Location field is empty";
            } else if (file2.exists() && !file2.isDirectory()) {
                string = "Location field path is not a directory";
            } else if (PySdkExtKt.isNotEmptyDirectory(file2)) {
                string = "Location directory is not empty";
            } else {
                return null;
            }
            String message = string;
            return new ValidationInfo(message, (JComponent)field);
        }

        @JvmStatic
        @Nullable
        protected final ValidationInfo validateAnacondaPresense(@Nullable JComponent component) {
            return PyCondaPackageService.getSystemCondaExecutable() == null ? new ValidationInfo("Anaconda installation is not found", component) : null;
        }

        @JvmStatic
        @Nullable
        protected final ValidationInfo validateSdkComboBox(@NotNull PySdkPathChoosingComboBox field) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
            return field.getSelectedSdk() == null ? new ValidationInfo("Interpreter field is empty", (JComponent)((Object)field)) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

