/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move.makeFunctionTopLevel;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.move.makeFunctionTopLevel.PyBaseMakeFunctionTopLevelProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyMakeMethodTopLevelProcessor
extends PyBaseMakeFunctionTopLevelProcessor {
    private final LinkedHashMap<String, String> myAttributeToParameterName;
    private final MultiMap<String, PyReferenceExpression> myAttributeReferences;
    private final Set<PsiElement> myReadsOfSelfParam;

    public PyMakeMethodTopLevelProcessor(@NotNull PyFunction targetFunction, @NotNull String destination) {
        if (targetFunction == null) {
            PyMakeMethodTopLevelProcessor.$$$reportNull$$$0(0);
        }
        if (destination == null) {
            PyMakeMethodTopLevelProcessor.$$$reportNull$$$0(1);
        }
        super(targetFunction, destination);
        this.myAttributeToParameterName = new LinkedHashMap();
        this.myAttributeReferences = MultiMap.create();
        this.myReadsOfSelfParam = new HashSet();
    }

    @Override
    @NotNull
    protected String getRefactoringName() {
        String string = PyBundle.message("refactoring.make.method.top.level.dialog.title", new Object[0]);
        if (string == null) {
            PyMakeMethodTopLevelProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void updateUsages(@NotNull Collection<String> newParamNames, @NotNull UsageInfo[] usages) {
        if (newParamNames == null) {
            PyMakeMethodTopLevelProcessor.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            PyMakeMethodTopLevelProcessor.$$$reportNull$$$0(4);
        }
        for (String attrName : this.myAttributeReferences.keySet()) {
            Collection reads = this.myAttributeReferences.get((Object)attrName);
            String paramName = this.myAttributeToParameterName.get(attrName);
            if (!attrName.equals(paramName)) {
                for (PyReferenceExpression read2 : reads) {
                    read2.replace((PsiElement)this.myGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)read2), paramName));
                }
                continue;
            }
            for (PyReferenceExpression read2 : reads) {
                this.removeQualifier(read2);
            }
        }
        Set<String> attrNames = this.myAttributeToParameterName.keySet();
        for (UsageInfo usage : usages) {
            PsiElement usageElem = usage.getElement();
            if (usageElem == null || !(usageElem instanceof PyReferenceExpression)) continue;
            PyExpression qualifier = ((PyReferenceExpression)usageElem).getQualifier();
            PyCallExpression callExpr = PyUtil.as(usageElem.getParent(), PyCallExpression.class);
            if (qualifier != null && callExpr != null && callExpr.getArgumentList() != null) {
                PyExpression instanceExpr = qualifier;
                PyArgumentList argumentList = callExpr.getArgumentList();
                if (this.resolvesToClass(qualifier)) {
                    PyExpression[] arguments = argumentList.getArguments();
                    if (arguments.length > 0) {
                        instanceExpr = arguments[0];
                        instanceExpr.delete();
                    } else {
                        instanceExpr = null;
                    }
                }
                if (instanceExpr != null) {
                    if (PyMakeMethodTopLevelProcessor.isPureReferenceExpression(instanceExpr)) {
                        if (this.myReadsOfSelfParam.contains(instanceExpr)) {
                            this.addArguments(argumentList, newParamNames);
                        } else {
                            String instanceExprText = instanceExpr.getText();
                            this.addArguments(argumentList, ContainerUtil.map(attrNames, attribute -> instanceExprText + "." + attribute));
                        }
                    } else if (newParamNames.size() == 1) {
                        this.addArguments(argumentList, Collections.singleton(instanceExpr.getText() + "." + (String)ContainerUtil.getFirstItem(attrNames)));
                    } else if (!newParamNames.isEmpty()) {
                        PyStatement anchor = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)callExpr, PyStatement.class);
                        String className = StringUtil.notNullize((String)this.myFunction.getContainingClass().getName(), (String)"object");
                        String targetName = PyRefactoringUtil.selectUniqueNameFromType(className, usageElem);
                        String assignmentText = targetName + " = " + instanceExpr.getText();
                        PyAssignmentStatement assignment = this.myGenerator.createFromText(LanguageLevel.forElement((PsiElement)callExpr), PyAssignmentStatement.class, assignmentText);
                        anchor.getParent().addBefore((PsiElement)assignment, (PsiElement)anchor);
                        this.addArguments(argumentList, ContainerUtil.map(attrNames, attribute -> targetName + "." + attribute));
                    }
                }
            }
            this.removeQualifier((PyReferenceExpression)usageElem);
        }
    }

    private boolean resolvesToClass(@NotNull PyExpression qualifier) {
        if (qualifier == null) {
            PyMakeMethodTopLevelProcessor.$$$reportNull$$$0(5);
        }
        for (PsiElement element : PyUtil.multiResolveTopPriority((PsiElement)qualifier, this.myResolveContext)) {
            if (element != this.myFunction.getContainingClass()) continue;
            return true;
        }
        return false;
    }

    private static boolean isPureReferenceExpression(@NotNull PyExpression expr) {
        if (expr == null) {
            PyMakeMethodTopLevelProcessor.$$$reportNull$$$0(6);
        }
        if (!(expr instanceof PyReferenceExpression)) {
            return false;
        }
        PyExpression qualifier = ((PyReferenceExpression)expr).getQualifier();
        return qualifier == null || PyMakeMethodTopLevelProcessor.isPureReferenceExpression(qualifier);
    }

    @NotNull
    private PyReferenceExpression removeQualifier(@NotNull PyReferenceExpression expr) {
        if (expr == null) {
            PyMakeMethodTopLevelProcessor.$$$reportNull$$$0(7);
        }
        if (!expr.isQualified()) {
            PyReferenceExpression pyReferenceExpression = expr;
            if (pyReferenceExpression == null) {
                PyMakeMethodTopLevelProcessor.$$$reportNull$$$0(8);
            }
            return pyReferenceExpression;
        }
        PyExpression newExpression = this.myGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)expr), expr.getLastChild().getText());
        PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)expr.replace((PsiElement)newExpression);
        if (pyReferenceExpression == null) {
            PyMakeMethodTopLevelProcessor.$$$reportNull$$$0(9);
        }
        return pyReferenceExpression;
    }

    @Override
    @NotNull
    protected PyFunction createNewFunction(@NotNull Collection<String> newParams) {
        PyFunction copied;
        PyParameter[] params;
        if (newParams == null) {
            PyMakeMethodTopLevelProcessor.$$$reportNull$$$0(10);
        }
        if ((params = (copied = (PyFunction)this.myFunction.copy()).getParameterList().getParameters()).length > 0) {
            params[0].delete();
        }
        this.addParameters(copied.getParameterList(), newParams);
        PyFunction pyFunction = copied;
        if (pyFunction == null) {
            PyMakeMethodTopLevelProcessor.$$$reportNull$$$0(11);
        }
        return pyFunction;
    }

    @Override
    @NotNull
    protected List<String> collectNewParameterNames() {
        LinkedHashSet<String> attributeNames = new LinkedHashSet<String>();
        for (ScopeOwner owner : PsiTreeUtil.collectElementsOfType((PsiElement)this.myFunction, (Class[])new Class[]{ScopeOwner.class})) {
            PyBaseMakeFunctionTopLevelProcessor.AnalysisResult result2 = this.analyseScope(owner);
            if (!result2.nonlocalWritesToEnclosingScope.isEmpty()) {
                throw new IncorrectOperationException(PyBundle.message("refactoring.make.function.top.level.error.nonlocal.writes", new Object[0]));
            }
            if (!result2.readsOfSelfParametersFromEnclosingScope.isEmpty()) {
                throw new IncorrectOperationException(PyBundle.message("refactoring.make.function.top.level.error.self.reads", new Object[0]));
            }
            if (!result2.readsFromEnclosingScope.isEmpty()) {
                throw new IncorrectOperationException(PyBundle.message("refactoring.make.function.top.level.error.outer.scope.reads", new Object[0]));
            }
            if (!result2.writesToSelfParameter.isEmpty()) {
                throw new IncorrectOperationException(PyBundle.message("refactoring.make.function.top.level.error.special.usage.of.self", new Object[0]));
            }
            this.myReadsOfSelfParam.addAll(result2.readsOfSelfParameter);
            for (PsiElement usage : result2.readsOfSelfParameter) {
                if (usage.getParent() instanceof PyTargetExpression) {
                    throw new IncorrectOperationException(PyBundle.message("refactoring.make.function.top.level.error.attribute.writes", new Object[0]));
                }
                PyReferenceExpression parentReference = PyUtil.as(usage.getParent(), PyReferenceExpression.class);
                if (parentReference != null) {
                    String attrName = parentReference.getName();
                    if (attrName != null && PyUtil.isClassPrivateName(attrName)) {
                        throw new IncorrectOperationException(PyBundle.message("refactoring.make.function.top.level.error.private.attributes", new Object[0]));
                    }
                    if (parentReference.getParent() instanceof PyCallExpression) {
                        if (Comparing.equal((String)this.myFunction.getName(), (String)parentReference.getName())) continue;
                        throw new IncorrectOperationException(PyBundle.message("refactoring.make.function.top.level.error.method.calls", new Object[0]));
                    }
                    attributeNames.add(attrName);
                    this.myAttributeReferences.putValue((Object)attrName, (Object)parentReference);
                    continue;
                }
                throw new IncorrectOperationException(PyBundle.message("refactoring.make.function.top.level.error.special.usage.of.self", new Object[0]));
            }
        }
        for (String name : attributeNames) {
            Collection reads;
            PsiElement anchor;
            if (!PyRefactoringUtil.isValidNewName(name, anchor = (PsiElement)ContainerUtil.getFirstItem((Collection)(reads = this.myAttributeReferences.get((Object)name))))) {
                String indexedName = PyRefactoringUtil.appendNumberUntilValid(name, anchor);
                this.myAttributeToParameterName.put(name, indexedName);
                continue;
            }
            this.myAttributeToParameterName.put(name, name);
        }
        ArrayList arrayList = Lists.newArrayList(this.myAttributeToParameterName.values());
        if (arrayList == null) {
            PyMakeMethodTopLevelProcessor.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFunction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/move/makeFunctionTopLevel/PyMakeMethodTopLevelProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParamNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/move/makeFunctionTopLevel/PyMakeMethodTopLevelProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeQualifier";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewFunction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNewParameterNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolvesToClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPureReferenceExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeQualifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createNewFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

