/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibDocumentationLinkProvider;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevDocumentationProvider;
import com.jetbrains.python.documentation.DocumentationBuilderKit;
import com.jetbrains.python.documentation.PyDocumentationBuilder;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.PyTypeModelBuilder;
import com.jetbrains.python.documentation.PythonDocumentationLinkProvider;
import com.jetbrains.python.documentation.PythonDocumentationMap;
import com.jetbrains.python.documentation.PythonDocumentationQuickInfoProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.toolbox.ChainIterable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class PythonDocumentationProvider
extends AbstractDocumentationProvider
implements ExternalDocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, @NotNull PsiElement originalElement) {
        if (originalElement == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(0);
        }
        for (PythonDocumentationQuickInfoProvider point : (PythonDocumentationQuickInfoProvider[])PythonDocumentationQuickInfoProvider.EP_NAME.getExtensions()) {
            String info = point.getQuickInfo(originalElement);
            if (info == null) continue;
            return info;
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(originalElement.getProject(), originalElement.getContainingFile());
        if (element instanceof PyFunction) {
            String clsName;
            PyFunction function = (PyFunction)element;
            ChainIterable<String> result2 = new ChainIterable<String>();
            PyClass cls = function.getContainingClass();
            if (cls != null && (clsName = cls.getName()) != null) {
                result2.addItem("class ").addItem(clsName).addItem("\n");
            }
            result2.add(PythonDocumentationProvider.describeDecorators(function, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, ", ", "\n")).add(PythonDocumentationProvider.describeFunction(function, Function.identity(), DocumentationBuilderKit.ESCAPE_ONLY, context));
            String docStringSummary = PythonDocumentationProvider.getDocStringSummary(function);
            if (docStringSummary != null) {
                result2.addItem("\n").addItem(docStringSummary);
            }
            return result2.toString();
        }
        if (element instanceof PyClass) {
            PyClass cls = (PyClass)element;
            ChainIterable<String> result3 = new ChainIterable<String>();
            result3.add(PythonDocumentationProvider.describeDecorators(cls, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, ", ", "\n")).add(PythonDocumentationProvider.describeClass(cls, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, false, false, context));
            String docStringSummary = PythonDocumentationProvider.getDocStringSummary(cls);
            if (docStringSummary != null) {
                result3.addItem("\n").addItem(docStringSummary);
            } else {
                Optional.ofNullable(cls.findInitOrNew(false, context)).map(PythonDocumentationProvider::getDocStringSummary).ifPresent(summary -> result3.addItem("\n").addItem((String)summary));
            }
            return result3.toString();
        }
        if (element instanceof PyExpression) {
            return PythonDocumentationProvider.describeExpression((PyExpression)element, originalElement, DocumentationBuilderKit.ESCAPE_ONLY, context);
        }
        return null;
    }

    @Nullable
    private static String getDocStringSummary(@NotNull PyDocStringOwner owner) {
        PyStringLiteralExpression docStringExpression;
        if (owner == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(1);
        }
        if ((docStringExpression = PyDocumentationBuilder.getEffectiveDocStringExpression(owner)) != null) {
            StructuredDocString docString = DocStringUtil.parse(docStringExpression.getStringValue(), docStringExpression);
            return docString.getSummary();
        }
        return null;
    }

    @NotNull
    static ChainIterable<String> describeFunction(@NotNull PyFunction function, @NotNull Function<String, String> escapedNameMapper, @NotNull Function<String, String> escaper, @NotNull TypeEvalContext context) {
        List<PyFunction> overloads;
        if (function == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (escapedNameMapper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(3);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (!(overloads = PyiUtil.getOverloads(function, context)).isEmpty()) {
            ChainIterable<String> chainIterable = PythonDocumentationProvider.describeOverload(function, overloads, escapedNameMapper, escaper, context);
            if (chainIterable == null) {
                PythonDocumentationProvider.$$$reportNull$$$0(6);
            }
            return chainIterable;
        }
        ChainIterable<String> result2 = new ChainIterable<String>();
        String name = function.getName();
        result2.addItem(escaper.apply("def ")).addItem(escapedNameMapper.apply(escaper.apply(name))).addItem(escaper.apply(PyUtil.getReadableRepr((PsiElement)function.getParameterList(), false)));
        if (!"__init__".equals(name)) {
            result2.addItem(escaper.apply("\nInferred type: "));
            PythonDocumentationProvider.describeTypeWithLinks(context.getType(function), context, function, result2);
        }
        ChainIterable<String> chainIterable = result2;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(7);
        }
        return chainIterable;
    }

    @NotNull
    private static ChainIterable<String> describeOverload(@NotNull PyFunction function, @NotNull List<PyFunction> overloads, @NotNull Function<String, String> escapedNameMapper, @NotNull Function<String, String> escaper, @NotNull TypeEvalContext context) {
        if (function == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (overloads == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(9);
        }
        if (escapedNameMapper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(12);
        }
        ChainIterable<String> result2 = new ChainIterable<String>();
        String name = function.getName();
        result2.addItem(escaper.apply("def ")).addItem(escapedNameMapper.apply(escaper.apply(name))).addItem(escaper.apply("\nPossible types:\n"));
        boolean first = true;
        for (PyFunction overload : overloads) {
            if (!first) {
                result2.addItem(escaper.apply("\n"));
            }
            result2.addItem(escaper.apply("\u2022 "));
            PythonDocumentationProvider.describeTypeWithLinks(context.getType(overload), context, function, result2);
            first = false;
        }
        ChainIterable<String> chainIterable = result2;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(13);
        }
        return chainIterable;
    }

    @Nullable
    private static String describeExpression(@NotNull PyExpression expression, @NotNull PsiElement originalElement, @NotNull Function<String, String> escaper, @NotNull TypeEvalContext context) {
        String name;
        if (expression == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(14);
        }
        if (originalElement == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(15);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(16);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(17);
        }
        if ((name = expression.getName()) != null) {
            PyFunction function;
            StringBuilder result2 = new StringBuilder(expression instanceof PyNamedParameter ? "parameter" : "variable");
            result2.append(String.format(" \"%s\"", name));
            if (expression instanceof PyNamedParameter && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, PyFunction.class)) != null) {
                result2.append(" of ").append(function.getContainingClass() == null ? "function" : "method").append(String.format(" \"%s\"", function.getName()));
            }
            if (originalElement instanceof PyTypedElement) {
                String typeName = PythonDocumentationProvider.getTypeName(context.getType((PyTypedElement)originalElement), context);
                result2.append("\n").append(String.format("Inferred type: %s", typeName));
            }
            return escaper.apply(result2.toString());
        }
        return null;
    }

    @NotNull
    public static String getTypeName(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(18);
        }
        String string = PythonDocumentationProvider.buildTypeModel(type, context).asString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(19);
        }
        return string;
    }

    public static void describeTypeWithLinks(@Nullable PyType type, @NotNull TypeEvalContext context, @NotNull PsiElement anchor, @NotNull ChainIterable<String> body) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(20);
        }
        if (anchor == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(21);
        }
        if (body == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(22);
        }
        PythonDocumentationProvider.buildTypeModel(type, context).toBodyWithLinks(body, anchor);
    }

    @NotNull
    public static String getTypeDescription(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(23);
        }
        String string = PythonDocumentationProvider.buildTypeModel(type, context).asDescription();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static PyTypeModelBuilder.TypeModel buildTypeModel(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(25);
        }
        PyTypeModelBuilder.TypeModel typeModel = new PyTypeModelBuilder(context).build(type, true);
        if (typeModel == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(26);
        }
        return typeModel;
    }

    @NotNull
    static ChainIterable<String> describeDecorators(@NotNull PyDecoratable decoratable, @NotNull Function<String, String> escapedCalleeMapper, @NotNull Function<String, String> escaper, @NotNull String separator, @NotNull String suffix) {
        if (decoratable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(27);
        }
        if (escapedCalleeMapper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(28);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(29);
        }
        if (separator == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(30);
        }
        if (suffix == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(31);
        }
        ChainIterable<String> result2 = new ChainIterable<String>();
        PyDecoratorList decoratorList = decoratable.getDecoratorList();
        if (decoratorList != null) {
            boolean first = true;
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                if (!first) {
                    result2.addItem(separator);
                }
                result2.add(PythonDocumentationProvider.describeDecorator(decorator, escapedCalleeMapper, escaper));
                first = false;
            }
        }
        if (!result2.isEmpty()) {
            result2.addItem(suffix);
        }
        ChainIterable<String> chainIterable = result2;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(32);
        }
        return chainIterable;
    }

    @NotNull
    static ChainIterable<String> describeClass(@NotNull PyClass cls, @NotNull Function<String, String> escapedNameMapper, @NotNull Function<String, String> escaper, boolean link, boolean linkAncestors, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(33);
        }
        if (escapedNameMapper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(34);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(35);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(36);
        }
        ChainIterable<String> result2 = new ChainIterable<String>();
        String name = escapedNameMapper.apply(escaper.apply(cls.getName()));
        result2.addItem(escaper.apply("class "));
        result2.addItem(link ? PyDocumentationLink.toContainingClass(name) : name);
        PyExpression[] superClasses = cls.getSuperClassExpressions();
        if (superClasses.length > 0) {
            result2.addItem(escaper.apply("("));
            boolean isNotFirst = false;
            for (PyExpression superClass : superClasses) {
                if (isNotFirst) {
                    result2.addItem(escaper.apply(", "));
                } else {
                    isNotFirst = true;
                }
                result2.addItem(PythonDocumentationProvider.describeSuperClass(superClass, escaper, linkAncestors, context));
            }
            result2.addItem(escaper.apply(")"));
        }
        ChainIterable<String> chainIterable = result2;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(37);
        }
        return chainIterable;
    }

    @NotNull
    private static String describeSuperClass(@NotNull PyExpression expression, @NotNull Function<String, String> escaper, boolean link, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(38);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(39);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(40);
        }
        if (link) {
            PyCallExpression callExpression;
            PyExpression callee;
            if (expression instanceof PyReferenceExpression) {
                PyReferenceExpression referenceExpression = (PyReferenceExpression)expression;
                if (!referenceExpression.isQualified()) {
                    PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
                    for (ResolveResult result2 : referenceExpression.getReference(resolveContext).multiResolve(false)) {
                        String qualifiedName;
                        PsiElement element = result2.getElement();
                        if (!(element instanceof PyClass) || (qualifiedName = ((PyClass)element).getQualifiedName()) == null) continue;
                        String string = PyDocumentationLink.toPossibleClass(escaper.apply(expression.getText()), qualifiedName, element, context);
                        if (string == null) {
                            PythonDocumentationProvider.$$$reportNull$$$0(41);
                        }
                        return string;
                    }
                }
            } else if (expression instanceof PySubscriptionExpression) {
                PyExpression operand = ((PySubscriptionExpression)expression).getOperand();
                PyExpression indexExpression = ((PySubscriptionExpression)expression).getIndexExpression();
                if (indexExpression != null) {
                    String string = PythonDocumentationProvider.describeSuperClass(operand, escaper, true, context) + escaper.apply("[") + PythonDocumentationProvider.describeSuperClass(indexExpression, escaper, true, context) + escaper.apply("]");
                    if (string == null) {
                        PythonDocumentationProvider.$$$reportNull$$$0(42);
                    }
                    return string;
                }
            } else if (expression instanceof PyKeywordArgument) {
                String keyword = ((PyKeywordArgument)expression).getKeyword();
                PyExpression valueExpression = ((PyKeywordArgument)expression).getValueExpression();
                if ("metaclass".equals(keyword) && valueExpression != null) {
                    String string = escaper.apply("metaclass=") + PythonDocumentationProvider.describeSuperClass(valueExpression, escaper, true, context);
                    if (string == null) {
                        PythonDocumentationProvider.$$$reportNull$$$0(43);
                    }
                    return string;
                }
            } else if (PyClassImpl.isSixWithMetaclassCall(expression) && (callee = (callExpression = (PyCallExpression)expression).getCallee()) != null) {
                String string = StreamEx.of((Object[])callExpression.getArguments()).map(argument -> {
                    if (escaper == null) {
                        PythonDocumentationProvider.$$$reportNull$$$0(57);
                    }
                    if (context == null) {
                        PythonDocumentationProvider.$$$reportNull$$$0(58);
                    }
                    return PythonDocumentationProvider.describeSuperClass(argument, escaper, true, context);
                }).joining((CharSequence)escaper.apply(", "), (CharSequence)escaper.apply(callee.getText() + "("), (CharSequence)escaper.apply(")"));
                if (string == null) {
                    PythonDocumentationProvider.$$$reportNull$$$0(44);
                }
                return string;
            }
        }
        String string = escaper.apply(expression.getText());
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    private static Iterable<String> describeDecorator(@NotNull PyDecorator decorator, @NotNull Function<String, String> escapedCalleeMapper, @NotNull Function<String, String> escaper) {
        if (decorator == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(46);
        }
        if (escapedCalleeMapper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(47);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(48);
        }
        ChainIterable<String> result2 = new ChainIterable<String>();
        result2.addItem(escaper.apply("@")).addItem(escapedCalleeMapper.apply(escaper.apply(PyUtil.getReadableRepr((PsiElement)decorator.getCallee(), false))));
        PyArgumentList argumentList = decorator.getArgumentList();
        if (argumentList != null) {
            result2.addItem(escaper.apply(PyUtil.getReadableRepr((PsiElement)argumentList, false)));
        }
        ChainIterable<String> chainIterable = result2;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(49);
        }
        return chainIterable;
    }

    public String generateDoc(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        if (element != null && PydevConsoleRunner.isInPydevConsole(element) || originalElement != null && PydevConsoleRunner.isInPydevConsole(originalElement)) {
            return PydevDocumentationProvider.createDoc(element, originalElement);
        }
        return new PyDocumentationBuilder(element, originalElement).build();
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, @NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(50);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(51);
        }
        return PyDocumentationLink.elementForLink(link, context, TypeEvalContext.userInitiated(context.getProject(), context.getContainingFile()));
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String url = PythonDocumentationProvider.getUrlFor(element, originalElement, true);
        return url == null ? null : Collections.singletonList(url);
    }

    @Nullable
    public static String getUrlFor(PsiElement element, PsiElement originalElement, boolean checkExistence) {
        String url;
        PyClass containingClass;
        Object namedElement;
        Sdk sdk;
        PsiFileSystemItem file2;
        Object object = file2 = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
        if (file2 == null) {
            return null;
        }
        if ("__init__.py".equals(file2.getName())) {
            file2 = file2.getParent();
            assert (file2 != null);
        }
        if ((sdk = PyBuiltinCache.findSdkForFile(file2)) == null) {
            return null;
        }
        QualifiedName qName = QualifiedNameFinder.findCanonicalImportPath(element, originalElement);
        if (qName == null) {
            return null;
        }
        PythonDocumentationMap map2 = PythonDocumentationMap.getInstance();
        String pyVersion = PythonDocumentationProvider.pyVersion(sdk.getVersionString());
        PsiNamedElement psiNamedElement = namedElement = element instanceof PsiNamedElement && !(element instanceof PsiFileSystemItem) ? (PsiNamedElement)element : null;
        if (namedElement instanceof PyFunction && "__init__".equals(namedElement.getName()) && (containingClass = ((PyFunction)namedElement).getContainingClass()) != null) {
            namedElement = containingClass;
        }
        if ((url = map2.urlFor(qName, (PsiNamedElement)namedElement, pyVersion)) != null) {
            if (checkExistence && !PythonDocumentationProvider.pageExists(url)) {
                return map2.rootUrlFor(qName);
            }
            return url;
        }
        for (PythonDocumentationLinkProvider provider : (PythonDocumentationLinkProvider[])Extensions.getExtensions(PythonDocumentationLinkProvider.EP_NAME)) {
            String providerUrl = provider.getExternalDocumentationUrl(element, originalElement);
            if (providerUrl == null) continue;
            if (checkExistence && !PythonDocumentationProvider.pageExists(providerUrl)) {
                return provider.getExternalDocumentationRoot(sdk);
            }
            return providerUrl;
        }
        return null;
    }

    private static boolean pageExists(@NotNull String url) {
        if (url == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(52);
        }
        if (new File(url).exists()) {
            return true;
        }
        HttpClient client = new HttpClient();
        HttpConnectionManagerParams params = client.getHttpConnectionManager().getParams();
        params.setSoTimeout(5000);
        params.setConnectionTimeout(5000);
        try {
            HeadMethod method = new HeadMethod(url);
            int rc = client.executeMethod((HttpMethod)method);
            if (rc == 404) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Nullable
    public static String pyVersion(@Nullable String versionString) {
        String version;
        int dot;
        String prefix = "Python ";
        if (versionString != null && versionString.startsWith("Python ") && (dot = (version = versionString.substring("Python ".length())).indexOf(46)) > 0) {
            if ((dot = version.indexOf(46, dot + 1)) > 0) {
                return version.substring(0, dot);
            }
            return version;
        }
        return null;
    }

    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        return (String)ApplicationManager.getApplication().runReadAction(() -> {
            PyStdlibDocumentationLinkProvider stdlibDocumentationLinkProvider;
            String url;
            PyClass containingClass;
            Object namedElement;
            Sdk sdk;
            PsiFileSystemItem file2;
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module2 != null && !PyDocumentationSettings.getInstance(module2).isRenderExternalDocumentation()) {
                return null;
            }
            Object object = file2 = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
            if (file2 instanceof PyiFile) {
                return null;
            }
            if (file2 == null) {
                return null;
            }
            if ("__init__.py".equals(file2.getName())) {
                file2 = file2.getParent();
                assert (file2 != null);
            }
            if ((sdk = PyBuiltinCache.findSdkForFile(file2)) == null) {
                return null;
            }
            QualifiedName moduleQName = QualifiedNameFinder.findCanonicalImportPath(element, element);
            if (moduleQName == null) {
                return null;
            }
            PsiNamedElement psiNamedElement = namedElement = element instanceof PsiNamedElement && !(element instanceof PsiFileSystemItem) ? (PsiNamedElement)element : null;
            if (namedElement instanceof PyFunction && "__init__".equals(namedElement.getName()) && (containingClass = ((PyFunction)namedElement).getContainingClass()) != null) {
                namedElement = containingClass;
            }
            if ((url = (stdlibDocumentationLinkProvider = (PyStdlibDocumentationLinkProvider)Extensions.findExtension(PythonDocumentationLinkProvider.EP_NAME, PyStdlibDocumentationLinkProvider.class)).getExternalDocumentationUrl(element, element)) == null) {
                return null;
            }
            try {
                Document document = Jsoup.parse((URL)new URL(url), (int)1000);
                String elementId = namedElement != null ? moduleQName + "." + namedElement.getName() : "module-" + moduleQName;
                document.select("a.headerlink").remove();
                Elements parents = document.getElementsByAttributeValue("id", elementId).parents();
                if (parents.isEmpty()) {
                    Elements moduleElement = document.getElementsByAttributeValue("id", "module-" + moduleQName.toString());
                    if (moduleElement != null) {
                        return moduleElement.toString();
                    }
                    return document.toString();
                }
                return ((Element)parents.get(0)).toString();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        });
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return PythonDocumentationProvider.getUrlFor(element, originalElement, false) != null;
    }

    public boolean canPromptToConfigureDocumentation(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(53);
        }
        if ((containingFile = element.getContainingFile()) instanceof PyFile) {
            QualifiedName qName;
            Project project = element.getProject();
            VirtualFile vFile = containingFile.getVirtualFile();
            if (vFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(vFile) && (qName = QualifiedNameFinder.findCanonicalImportPath(element, element)) != null && qName.getComponentCount() > 0) {
                return true;
            }
        }
        return false;
    }

    public void promptToConfigureDocumentation(@NotNull PsiElement element) {
        if (element == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(54);
        }
        Project project = element.getProject();
        QualifiedName qName = QualifiedNameFinder.findCanonicalImportPath(element, element);
        if (qName != null && qName.getComponentCount() > 0) {
            ApplicationManager.getApplication().invokeLater(() -> {
                int rc = Messages.showOkCancelDialog((Project)project, (String)("No external documentation URL configured for module " + (String)qName.getComponents().get(0) + ".\nWould you like to configure it now?"), (String)"Python External Documentation", (Icon)Messages.getQuestionIcon());
                if (rc == 0) {
                    ShowSettingsUtilImpl.showSettingsDialog(project, "com.jetbrains.python.documentation.PythonDocumentationConfigurable", "");
                }
            }, ModalityState.NON_MODAL);
        }
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file2, @Nullable PsiElement contextElement) {
        if (editor == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(55);
        }
        if (file2 == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(56);
        }
        if (contextElement != null) {
            PyDocStringOwner docstringOwner;
            PsiReference reference;
            PyExpression callee;
            PyExpression expression;
            IElementType elementType = contextElement.getNode().getElementType();
            if (PythonDialectsTokenSetProvider.INSTANCE.getKeywordTokens().contains(elementType)) {
                return contextElement;
            }
            PsiElement parent = contextElement.getParent();
            if (parent instanceof PyArgumentList && (PyTokenTypes.LPAR == elementType || PyTokenTypes.RPAR == elementType) && (expression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyCallExpression.class)) != null && (callee = expression.getCallee()) != null && (reference = callee.getReference()) != null) {
                return reference.resolve();
            }
            expression = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyExpression.class);
            if (expression != null && DocStringUtil.isDocStringExpression(expression) && (docstringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyDocStringOwner.class)) != null) {
                return docstringOwner;
            }
        }
        return super.getCustomDocumentationElement(editor, file2, contextElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 19: 
            case 24: 
            case 26: 
            case 32: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 19: 
            case 24: 
            case 26: 
            case 32: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 10: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedNameMapper";
                break;
            }
            case 4: 
            case 11: 
            case 16: 
            case 29: 
            case 35: 
            case 39: 
            case 48: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escaper";
                break;
            }
            case 5: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 36: 
            case 40: 
            case 51: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 19: 
            case 24: 
            case 26: 
            case 32: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PythonDocumentationProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloads";
                break;
            }
            case 14: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratable";
                break;
            }
            case 28: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedCalleeMapper";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PythonDocumentationProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "describeFunction";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "describeOverload";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDescription";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeModel";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "describeDecorators";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "describeClass";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "describeSuperClass";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "describeDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDocStringSummary";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "describeFunction";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 19: 
            case 24: 
            case 26: 
            case 32: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "describeOverload";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "describeExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "describeTypeWithLinks";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDescription";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeModel";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "describeDecorators";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "describeClass";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "describeSuperClass";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "describeDecorator";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElementForLink";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "pageExists";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "canPromptToConfigureDocumentation";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "promptToConfigureDocumentation";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$describeSuperClass$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 19: 
            case 24: 
            case 26: 
            case 32: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

