/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StringLiteralExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertVariadicParamIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.convert.variadic.param", new Object[0]);
        if (string == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.variadic.param", new Object[0]);
        if (string == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(2);
        }
        if (!(file2 instanceof PyFile)) {
            return false;
        }
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (function != null) {
            if (LanguageLevel.forElement(function).isOlderThan(LanguageLevel.PYTHON30) && function.getParameterList().hasPositionalContainer()) {
                return false;
            }
            boolean caretInParameterList = PsiTreeUtil.isAncestor((PsiElement)function.getParameterList(), (PsiElement)element, (boolean)true);
            for (PyCallExpression call : ConvertVariadicParamIntention.findKeywordContainerCalls(function)) {
                PyExpression firstArgument = (PyExpression)ArrayUtil.getFirstElement((Object[])call.getArguments());
                String firstArgumentValue = PyStringLiteralUtil.getStringValue((PsiElement)firstArgument);
                if (firstArgumentValue == null || !PyNames.isIdentifier(firstArgumentValue) || !caretInParameterList && !PsiTreeUtil.isAncestor((PsiElement)call, (PsiElement)element, (boolean)true)) continue;
                return true;
            }
            for (PySubscriptionExpression subscription : ConvertVariadicParamIntention.findKeywordContainerSubscriptions(function)) {
                PyExpression indexExpression = subscription.getIndexExpression();
                String indexValue = PyStringLiteralUtil.getStringValue((PsiElement)indexExpression);
                if (indexValue == null || !PyNames.isIdentifier(indexValue) || !caretInParameterList && !PsiTreeUtil.isAncestor((PsiElement)subscription, (PsiElement)element, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PyParameter getKeywordContainer(@NotNull PyParameterList parameterList) {
        if (parameterList == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(3);
        }
        return StreamEx.of((Object[])parameterList.getParameters()).select(PyNamedParameter.class).findFirst(PyNamedParameter::isKeywordContainer).orElse(null);
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiElement element;
        PyFunction function;
        if (project == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(4);
        }
        if ((function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(element = file2.findElementAt(editor.getCaretModel().getOffset())), PyFunction.class)) != null) {
            ConvertVariadicParamIntention.replaceKeywordContainerSubscriptions(function, project);
            ConvertVariadicParamIntention.replaceKeywordContainerCalls(function, project);
        }
    }

    @NotNull
    private static List<PySubscriptionExpression> findKeywordContainerSubscriptions(@NotNull PyFunction function) {
        if (function == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(5);
        }
        List<PySubscriptionExpression> list2 = ConvertVariadicParamIntention.findKeywordContainerUsages(function, ConvertVariadicParamIntention::isKeywordContainerSubscription);
        if (list2 == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    private static List<PyCallExpression> findKeywordContainerCalls(@NotNull PyFunction function) {
        if (function == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(7);
        }
        List<PyCallExpression> list2 = ConvertVariadicParamIntention.findKeywordContainerUsages(function, ConvertVariadicParamIntention::isKeywordContainerCall);
        if (list2 == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private static void replaceKeywordContainerSubscriptions(@NotNull PyFunction function, @NotNull Project project) {
        if (function == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(9);
        }
        if (project == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(10);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        for (PySubscriptionExpression subscription : ConvertVariadicParamIntention.findKeywordContainerSubscriptions(function)) {
            Optional.ofNullable(subscription.getIndexExpression()).map(indexExpression -> PyUtil.as(indexExpression, PyStringLiteralExpression.class)).map(StringLiteralExpression::getStringValue).filter(PyNames::isIdentifier).ifPresent(indexValue -> {
                if (function == null) {
                    ConvertVariadicParamIntention.$$$reportNull$$$0(31);
                }
                PyExpression parameter = elementGenerator.createExpressionFromText(LanguageLevel.forElement(function), (String)indexValue);
                ConvertVariadicParamIntention.insertParameter(function.getParameterList(), parameter, false, elementGenerator);
                subscription.replace((PsiElement)parameter);
            });
        }
    }

    private static void replaceKeywordContainerCalls(@NotNull PyFunction function, @NotNull Project project) {
        if (function == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(11);
        }
        if (project == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(12);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        for (PyCallExpression call : ConvertVariadicParamIntention.findKeywordContainerCalls(function)) {
            Optional.of(call.getArguments()).map(ArrayUtil::getFirstElement).map(firstArgument -> PyUtil.as(firstArgument, PyStringLiteralExpression.class)).map(StringLiteralExpression::getStringValue).filter(PyNames::isIdentifier).ifPresent(indexValue -> {
                if (function == null) {
                    ConvertVariadicParamIntention.$$$reportNull$$$0(30);
                }
                PyNamedParameter parameter = ConvertVariadicParamIntention.createParameter(elementGenerator, call, indexValue);
                PyExpression parameterUsage = elementGenerator.createExpressionFromText(LanguageLevel.forElement(function), (String)indexValue);
                ConvertVariadicParamIntention.insertParameter(function.getParameterList(), parameter, parameter.hasDefaultValue(), elementGenerator);
                call.replace((PsiElement)parameterUsage);
            });
        }
    }

    @NotNull
    private static <T> List<T> findKeywordContainerUsages(@NotNull PyFunction function, @NotNull BiPredicate<PsiElement, String> usagePredicate) {
        PyParameter keywordContainer;
        String keywordContainerName;
        if (function == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(13);
        }
        if (usagePredicate == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(14);
        }
        String string = keywordContainerName = (keywordContainer = ConvertVariadicParamIntention.getKeywordContainer(function.getParameterList())) == null ? null : keywordContainer.getName();
        if (keywordContainerName != null) {
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
            Stack stack = new Stack();
            for (PyStatement statement : function.getStatementList().getStatements()) {
                stack.push((Object)statement);
                while (!stack.isEmpty()) {
                    PsiElement element = (PsiElement)stack.pop();
                    if (usagePredicate.test(element, keywordContainerName)) {
                        result2.add(element);
                        continue;
                    }
                    for (PsiElement child : element.getChildren()) {
                        stack.push((Object)child);
                    }
                }
            }
            ArrayList<PsiElement> arrayList = result2;
            if (arrayList == null) {
                ConvertVariadicParamIntention.$$$reportNull$$$0(15);
            }
            return arrayList;
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(16);
        }
        return list2;
    }

    private static boolean isKeywordContainerSubscription(@Nullable PsiElement element, @NotNull String keywordContainerName) {
        if (keywordContainerName == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(17);
        }
        return element instanceof PySubscriptionExpression && keywordContainerName.equals(((PySubscriptionExpression)element).getOperand().getText());
    }

    private static boolean isKeywordContainerCall(@Nullable PsiElement element, @NotNull String keywordContainerName) {
        if (keywordContainerName == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(18);
        }
        return Optional.ofNullable(PyUtil.as(element, PyCallExpression.class)).map(PyCallExpression::getCallee).map(callee -> PyUtil.as(callee, PyQualifiedExpression.class)).filter(callee -> {
            PyExpression qualifier;
            if (keywordContainerName == null) {
                ConvertVariadicParamIntention.$$$reportNull$$$0(29);
            }
            return (qualifier = callee.getQualifier()) != null && qualifier.getText().equals(keywordContainerName) && ArrayUtil.contains((String)callee.getReferencedName(), (String[])new String[]{"get", "__getitem__"});
        }).isPresent();
    }

    private static void insertParameter(@NotNull PyParameterList parameterList, @NotNull PyElement parameter, boolean hasDefaultValue, @NotNull PyElementGenerator elementGenerator) {
        if (parameterList == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(19);
        }
        if (parameter == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(20);
        }
        if (elementGenerator == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(21);
        }
        PyElement placeToInsertParameter = ConvertVariadicParamIntention.findCompatiblePlaceToInsertParameter(parameterList, hasDefaultValue);
        parameterList.addBefore((PsiElement)parameter, (PsiElement)placeToInsertParameter);
        parameterList.addBefore((PsiElement)elementGenerator.createComma(), (PsiElement)placeToInsertParameter);
    }

    @NotNull
    private static PyNamedParameter createParameter(@NotNull PyElementGenerator elementGenerator, @NotNull PyCallExpression call, @NotNull String parameterName) {
        PyExpression[] arguments;
        if (elementGenerator == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(22);
        }
        if (call == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(23);
        }
        if (parameterName == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(24);
        }
        if ((arguments = call.getArguments()).length > 1) {
            PyNamedParameter pyNamedParameter = elementGenerator.createParameter(parameterName + "=" + arguments[1].getText());
            if (pyNamedParameter == null) {
                ConvertVariadicParamIntention.$$$reportNull$$$0(25);
            }
            return pyNamedParameter;
        }
        PyQualifiedExpression callee = PyUtil.as(call.getCallee(), PyQualifiedExpression.class);
        if (callee != null && "get".equals(callee.getReferencedName())) {
            PyNamedParameter pyNamedParameter = elementGenerator.createParameter(parameterName + "=" + "None");
            if (pyNamedParameter == null) {
                ConvertVariadicParamIntention.$$$reportNull$$$0(26);
            }
            return pyNamedParameter;
        }
        PyNamedParameter pyNamedParameter = elementGenerator.createParameter(parameterName);
        if (pyNamedParameter == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(27);
        }
        return pyNamedParameter;
    }

    @Nullable
    private static PyElement findCompatiblePlaceToInsertParameter(@NotNull PyParameterList parameterList, boolean hasDefaultValue) {
        if (parameterList == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(28);
        }
        if (hasDefaultValue) {
            return ConvertVariadicParamIntention.getKeywordContainer(parameterList);
        }
        List<PyParameter> parameters = Arrays.asList(parameterList.getParameters());
        for (Pair currentAndNext : ContainerUtil.zip(parameters, parameters.subList(1, parameters.size()))) {
            PyParameter current = (PyParameter)currentAndNext.getFirst();
            if (!(current instanceof PyNamedParameter) || !((PyNamedParameter)current).isPositionalContainer()) continue;
            return (PyElement)currentAndNext.getSecond();
        }
        return (PyElement)ContainerUtil.find((Object[])parameterList.getParameters(), p -> p.hasDefaultValue() || p instanceof PyNamedParameter && ((PyNamedParameter)p).isKeywordContainer());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/ConvertVariadicParamIntention";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagePredicate";
                break;
            }
            case 17: 
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordContainerName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementGenerator";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/ConvertVariadicParamIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findKeywordContainerSubscriptions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findKeywordContainerCalls";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findKeywordContainerUsages";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordContainer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findKeywordContainerSubscriptions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findKeywordContainerCalls";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceKeywordContainerSubscriptions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceKeywordContainerCalls";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findKeywordContainerUsages";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isKeywordContainerSubscription";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isKeywordContainerCall";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "insertParameter";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findCompatiblePlaceToInsertParameter";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isKeywordContainerCall$5";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$replaceKeywordContainerCalls$3";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$replaceKeywordContainerSubscriptions$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

