/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.enterProcessors;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.SmartEnterUtil;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.enterProcessors.EnterProcessor;

public class PyCommentBreakerEnterProcessor
implements EnterProcessor {
    @Override
    public boolean doEnter(Editor editor, PsiElement psiElement, boolean isModified) {
        PsiElement comment;
        if (isModified) {
            return false;
        }
        CaretModel caretModel = editor.getCaretModel();
        PsiElement atCaret = psiElement.getContainingFile().findElementAt(caretModel.getOffset());
        if (atCaret instanceof PsiWhiteSpace) {
            atCaret = atCaret.getPrevSibling();
        }
        if ((comment = PsiTreeUtil.getParentOfType((PsiElement)atCaret, PsiComment.class, (boolean)false)) != null) {
            SmartEnterUtil.plainEnter(editor);
            editor.getDocument().insertString(caretModel.getOffset(), (CharSequence)"# ");
            caretModel.moveToOffset(caretModel.getOffset() + 2);
            return true;
        }
        return false;
    }
}

