/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.editor.BaseQuoteHandler;

public class PyTripleQuoteBackspaceDelegate
extends BackspaceHandlerDelegate {
    private boolean isTripleQuote;

    public void beforeCharDeleted(char c, PsiFile file2, Editor editor) {
        this.isTripleQuote = false;
        if (c == '\"' || c == '\'' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            boolean mayBeTripleQuote;
            QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file2, editor);
            if (quoteHandler == null || !(quoteHandler instanceof BaseQuoteHandler)) {
                return;
            }
            int offset = editor.getCaretModel().getCurrentCaret().getOffset();
            String text = editor.getDocument().getText();
            boolean bl = mayBeTripleQuote = offset >= 3 && offset + 2 < text.length();
            if (mayBeTripleQuote) {
                HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
                boolean hasTripleQuoteAfter = offset + 2 < text.length() && text.charAt(offset) == c && text.charAt(offset + 1) == c && text.charAt(offset + 2) == c;
                this.isTripleQuote = quoteHandler.isOpeningQuote(iterator, offset - 1) && hasTripleQuoteAfter;
            }
        }
    }

    public boolean charDeleted(char c, PsiFile file2, Editor editor) {
        if (this.isTripleQuote) {
            int offset = editor.getCaretModel().getCurrentCaret().getOffset();
            editor.getDocument().deleteString(offset - 2, offset + 3);
            return true;
        }
        return false;
    }
}

